/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "javawritedeclaration.h"
#include "javawriteinitialization.h"
#include "driver.h"
#include "ui4.h"
#include "uic.h"
#include "databaseinfo.h"
#include "customwidgetsinfo.h"
#include "javautils.h"

#include <QTextStream>

#define JUIC_NO_EMBEDDED_ICON

extern bool generate_java_main_function;

namespace Java {

WriteDeclaration::WriteDeclaration(Uic *uic)
    : driver(uic->driver()), output(uic->output()), option(uic->option())
{
    this->uic = uic;
}

void WriteDeclaration::acceptUI(DomUI *node)
{
    QString qualifiedClassName = node->elementClass() + option.postfix;
    QString className = qualifiedClassName;

    QString varName = driver->findOrInsertWidget(node->elementWidget());
    QString widgetName = node->elementWidget()->attributeClass();

    QString package = driver->option().javaPackage;

    if (!package.isEmpty())
        output << "package " << package << ";\n\n";

    output << "import com.trolltech.qt.core.*;\n"
           << "import com.trolltech.qt.gui.*;\n"
           << "\n";

    output << "public class " << option.prefix << className << "\n"
           << "{\n";

    TreeWalker::acceptWidget(node->elementWidget());

    output << "\n"
           << option.indent << "public " << option.prefix << className << "() { super(); }\n"
            << "\n";

    WriteInitialization(uic).acceptUI(node);

    if (generate_java_main_function) {
        QString uiName = option.prefix + className;
        output << "    public static void main(String args[]) {" << endl
               << "        QApplication.initialize(args);" << endl
               << "        " << uiName << " ui = new " << uiName << "();" << endl
               << "        " << widgetName << " widget = new " << widgetName << "();" << endl
               << "        ui.setupUi(widget);" << endl
               << "        widget.show();" << endl
               << "        QApplication.exec();" << endl
               << "    }" << endl;
    }

    output << "}\n\n";
}

void WriteDeclaration::acceptWidget(DomWidget *node)
{
    QString className = QLatin1String("QWidget");
    if (node->hasAttributeClass())
        className = node->attributeClass();

    output << option.indent << "public " << uic->customWidgetsInfo()->realClassName(className) << " "
           << escapeVariableName(driver->findOrInsertWidget(node)) << ";\n";

    TreeWalker::acceptWidget(node);
}

void WriteDeclaration::acceptLayout(DomLayout *node)
{
    QString className = QLatin1String("QLayout");
    if (node->hasAttributeClass())
        className = node->attributeClass();

    output << option.indent << "public " << className << " "
           << escapeVariableName(driver->findOrInsertLayout(node)) << ";\n";

    TreeWalker::acceptLayout(node);
}

void WriteDeclaration::acceptSpacer(DomSpacer *node)
{
    output << option.indent << "public QSpacerItem "
           << escapeVariableName(driver->findOrInsertSpacer(node)) << ";\n";

    TreeWalker::acceptSpacer(node);
}

void WriteDeclaration::acceptActionGroup(DomActionGroup *node)
{
    output << option.indent << "public QActionGroup "
           << escapeVariableName(driver->findOrInsertActionGroup(node)) << ";\n";

    TreeWalker::acceptActionGroup(node);
}

void WriteDeclaration::acceptAction(DomAction *node)
{
    output << option.indent << "public QAction "
           << escapeVariableName(driver->findOrInsertAction(node)) << ";\n";

    TreeWalker::acceptAction(node);
}

} // namespace Java
