/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QDOC_GENERATOR
#define QDOC_GENERATOR

#include "javagenerator.h"
#include "metajava.h"

class QDocGenerator: public JavaGenerator
{
public:
    QDocGenerator();

    virtual void generate();
    virtual QString subDirectoryForClass(const MetaJavaClass *java_class) const;
    virtual QString fileNameForClass(const MetaJavaClass *java_class) const;
    virtual void write(QTextStream &s, const MetaJavaClass *java_class);
    virtual void write(QTextStream &s, const MetaJavaEnumValue *java_enum_value);
    virtual void write(QTextStream &s, const MetaJavaEnum *java_enum);
    virtual void writeOverload(QTextStream &s, const MetaJavaFunction *java_function, int arg_count);
    virtual void write(QTextStream &s, const MetaJavaFunction *java_function);
    virtual void write(QTextStream &s, const MetaJavaField *java_field);
    virtual void writeSignal(QTextStream &s, const MetaJavaFunction *java_function);
};

#endif // QDOC_GENERATOR
