/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef UICONVERTER_H
#define UICONVERTER_H

#include "metajava.h"

#include <QtXml>

class UiConverter
{
public:
    enum SearchType {
        SignalSearch,
        SlotSearch
    };

    void setClasses(const MetaJavaClassList &classes) { m_java_classes = classes; }
    MetaJavaClassList classes() const { return m_java_classes; }

    void convertToJui(const QString &uiFile);

private:
    void traverse(QDomNode node, QDomDocument *doc);
    void fixUiNode(QDomElement node, QDomDocument *doc);
    void fixSetNode(QDomElement node, QDomDocument *doc);
    void fixEnumNode(QDomElement node, QDomDocument *doc);
    void fixConnectionNode(QDomElement node, QDomDocument *doc);
    void fixWidgetNode(QDomElement, QDomDocument *doc);
    QString translateEnumValue(const QString &enumValue);
    const MetaJavaFunction *findFunction(MetaJavaClass *javaClass, const QString &signature,
                                         SearchType type);


    MetaJavaClassList m_java_classes;
    QHash<QString, MetaJavaClass *> m_named_widgets;
};

#endif // UICONVERTER_H
