/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef JUICDATAGENERATOR_H
#define JUICDATAGENERATOR_H

#include "metajava.h"

class QDomDocument;
class QDomElement;

class JuicDataGenerator
{
public:
    void setClasses(const MetaJavaClassList &classes) { m_classes = classes; }
    MetaJavaClassList classes() const { return m_classes; }

    void setFileName(const QString &outputFile) { m_file_name = outputFile; }
    QString fileName() const { return m_file_name; }

    void generate();
    void generateSignatures(QDomDocument *doc_node, QDomElement *signatures_node);
    void generateHierarchy(QDomDocument *doc_node, QDomElement *hierarchy_node);
    void generateModifications(QDomDocument *doc_nod, QDomElement *mods_node);
    void generateEnumerators(QDomDocument *doc_nod, QDomElement *mods_node);

private:
    MetaJavaClassList m_classes;
    QString m_file_name;
};

#endif // JUICDATAGENERATOR_H
