/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.qt;

/**
 * @exclude
 */
class QThreadManager {

    private static class NativeResourcesReleaseThread extends Thread {
        private int m_sleepTime = 100;

        public NativeResourcesReleaseThread() {
            setDaemon(true);
        }

        public void run() {
            while (true) {
                try { sleep(m_sleepTime); } catch (Exception e) { };
                boolean release = releaseNativeResources();
                m_sleepTime = release ? 100 : Math.min(m_sleepTime * 2, 60 * 1000);
            }
        }
    }

    public static void initialize() {
        new NativeResourcesReleaseThread().start();
    }

    public synchronized static native boolean releaseNativeResources();
}
