package com.trolltech.tools.designer.propertysheet;

import java.util.*;

import com.trolltech.qt.core.*;
import com.trolltech.qt.gui.*;
import com.trolltech.tools.designer.*;

public class WindowModalityProperty extends FakeProperty {
    private Qt.WindowModality value;

    public WindowModalityProperty() {
        super("windowModality");
        value = Qt.WindowModality.NonModal;
        this.subclassLevel = decideSubclassLevel(QWidget.class);
        this.groupName = "QWidget";
        attribute = false;
    }

    public Object read() {
        return PropertySheet.translateEnum(value);
    }

    public void write(Object value) {
        this.value = Qt.WindowModality.resolve((Integer) value);
    }

    @SuppressWarnings("deprecation")
    public static void initialize(List<Property> properties, QObject object) {
        if (object instanceof QWidget)
            properties.add(new WindowModalityProperty());       
    }
}