/****************************************************************************
 **
 ** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
 **
 ** This file is part of Qt Jambi.
 **
 ** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

package com.trolltech.tools.designer.propertysheet;

import com.trolltech.qt.core.*;
import com.trolltech.qt.gui.*;

import java.util.*;

public class LayoutProperty extends FakeProperty {

    public static final String RIGHT_MARGIN       = "rightMargin";
    public static final String LEFT_MARGIN        = "leftMargin";
    public static final String TOP_MARGIN         = "topMargin";
    public static final String BOTTOM_MARGIN      = "bottomMargin";
    public static final String VERTICAL_SPACING   = "verticalSpacing";
    public static final String HORIZONTAL_SPACING = "horizontalSpacing";

    public LayoutProperty(QLayout layout, String name) {
        super(name);
        this.layout = layout;
        attribute = false;
    }

    @SuppressWarnings("deprecation")
    public Object read() {
        if (entry.name.endsWith("Margin")) {
            QRect c = layout.contentsRect();
            QRect g = layout.geometry();
            if (entry.name == RIGHT_MARGIN) return g.right() - c.right();
            if (entry.name == LEFT_MARGIN) return c.left() - g.left();
            if (entry.name == TOP_MARGIN) return c.top() - g.top();
            if (entry.name == BOTTOM_MARGIN) return g.bottom() - c.bottom();
        }
        return null;
    }

    @SuppressWarnings("deprecation")
    public void write(Object value) {
        changed = true;
        if (entry.name.endsWith("Margin")) {
            int x = (Integer) value;

            QContentsMargins margins = layout.getContentsMargins();

            if (entry.name == RIGHT_MARGIN) margins.right = x;
            else if (entry.name == LEFT_MARGIN) margins.left = x;
            else if (entry.name == TOP_MARGIN) margins.top = x;
            else if (entry.name == BOTTOM_MARGIN) margins.bottom = x;

            layout.setContentsMargins(margins);
        }
    }

    public boolean designable() {
        return true;
    }

    public static void initialize(List<Property> properties, QObject object) {
        if (object instanceof QLayout) {
            QLayout l = (QLayout) object;
            properties.add(new LayoutProperty(l, RIGHT_MARGIN));
            properties.add(new LayoutProperty(l, LEFT_MARGIN));
            properties.add(new LayoutProperty(l, TOP_MARGIN));
            properties.add(new LayoutProperty(l, BOTTOM_MARGIN));
        }
    }

    private QLayout layout;
}
