/****************************************************************************
 **
 ** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
 **
 ** This file is part of Qt Jambi.
 **
 ** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

package com.trolltech.tools.designer.propertysheet;

import com.trolltech.qt.core.*;
import com.trolltech.qt.gui.*;

import java.util.*;

public class BuddyProperty extends FakeProperty {
    public BuddyProperty(QLabel label) {
        super("buddy");
        this.label = label;
        this.attribute = false;

        groupName = "QLabel";
        subclassLevel = decideSubclassLevel(QLabel.class);
    }

    public Object read() {
        QWidget buddy = label.buddy();
        if (buddy != null) {
            return new QByteArray(buddy.objectName());
        }
        return new QByteArray("");
    }

    public void write(Object name) {
        QWidget window = label.window();
        QWidget w = (QWidget) window.findChild(QWidget.class, name.toString());
        if (w != null)
            label.setBuddy(w);
    }

    private QLabel label;

    public static void initialize(List<Property> properties, QObject object) {
        if (object instanceof QLabel) {
            QLabel label = (QLabel) object;
            properties.add(new BuddyProperty(label));
        }
    }
}
