/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qtdesigner.editors;

import com.trolltech.qtdesigner.editors.DesignerAction;
import com.trolltech.qtdesigner.editors.UiEditor;
import com.trolltech.qtdesigner.views.FormWindowW;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.ActionFactory;

public class DesignerActionBarContributor
implements IEditorActionBarContributor {
    private ArrayList actions = null;
    private ArrayList tools = null;
    private IActionBars actionbars;
    private UiEditor editor;

    public void setActiveEditor(IEditorPart iEditorPart) {
        if (iEditorPart instanceof UiEditor) {
            this.editor = (UiEditor)iEditorPart;
            if (this.editor.formWindow() != null) {
                this.editor.formWindow().setActiveFormWindow();
                if (this.actions == null) {
                    this.setupActions();
                }
                this.updateTools();
            }
        }
    }

    public UiEditor activeEditor() {
        return this.editor;
    }

    public void init(IActionBars iActionBars, IWorkbenchPage iWorkbenchPage) {
        this.actionbars = iActionBars;
    }

    public void dispose() {
    }

    private void setupActions() {
        this.actions = new ArrayList();
        IToolBarManager iToolBarManager = this.actionbars.getToolBarManager();
        IMenuManager iMenuManager = this.actionbars.getMenuManager();
        FormWindowW formWindowW = this.activeEditor().formWindow();
        DesignerAction designerAction = new DesignerAction(this, 0, false);
        this.actionbars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)designerAction);
        this.actionbars.setGlobalActionHandler("cut.ext", (IAction)designerAction);
        this.actions.add(designerAction);
        designerAction = new DesignerAction(this, 1, false);
        this.actionbars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)designerAction);
        this.actions.add(designerAction);
        designerAction = new DesignerAction(this, 2, false);
        this.actionbars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)designerAction);
        this.actions.add(designerAction);
        designerAction = new DesignerAction(this, 3, false);
        this.actionbars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)designerAction);
        this.actions.add(designerAction);
        designerAction = new DesignerAction(this, 4, false);
        this.actionbars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)designerAction);
        this.actions.add(designerAction);
        designerAction = new DesignerAction(this, 5, false);
        this.actionbars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)designerAction);
        this.actionbars.setGlobalActionHandler("undo.ext", (IAction)designerAction);
        this.actions.add(designerAction);
        designerAction = new DesignerAction(this, 6, false);
        this.actionbars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)designerAction);
        this.actions.add(designerAction);
        MenuManager menuManager = new MenuManager("QtDesigner");
        iMenuManager.insertBefore("window", (IContributionItem)menuManager);
        for (int i = 7; i < formWindowW.staticActionCount() + 1; ++i) {
            designerAction = new DesignerAction(this, i, false);
            this.actions.add(designerAction);
            if (designerAction.hasIcon()) {
                iToolBarManager.add((IAction)designerAction);
            }
            menuManager.add((IAction)designerAction);
        }
        menuManager.insert(formWindowW.staticActionCount() - 7, (IContributionItem)new Separator());
        MenuManager menuManager2 = new MenuManager("Preview in");
        menuManager.add((IContributionItem)menuManager2);
        for (int i = formWindowW.staticActionCount() + 1; i < formWindowW.actionCount(); ++i) {
            designerAction = new DesignerAction(this, i, false);
            this.actions.add(designerAction);
            if (designerAction.hasIcon()) {
                iToolBarManager.add((IAction)designerAction);
            }
            menuManager2.add((IAction)designerAction);
        }
        this.tools = new ArrayList();
        iToolBarManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator());
        MenuManager menuManager3 = new MenuManager("Editor Mode");
        menuManager.add((IContributionItem)menuManager3);
        for (int i = 0; i < formWindowW.toolCount(); ++i) {
            designerAction = new DesignerAction(this, i, true);
            this.tools.add(designerAction);
            if (designerAction.hasIcon()) {
                iToolBarManager.add((IAction)designerAction);
            }
            menuManager3.add((IAction)designerAction);
        }
    }

    public IActionBars actionBars() {
        return this.actionbars;
    }

    public void updateAction(int n) {
        if (this.actions != null) {
            DesignerAction designerAction = (DesignerAction)this.actions.get(n);
            FormWindowW formWindowW = this.activeEditor().formWindow();
            String string = formWindowW.actionName(n);
            if (string != designerAction.getText()) {
                designerAction.setText(string);
            }
            designerAction.setEnabled(formWindowW.isEnabled(n));
        }
    }

    public void updateTools() {
        FormWindowW formWindowW = this.activeEditor().formWindow();
        for (int i = 0; i < this.tools.size(); ++i) {
            if (formWindowW.currentTool() == i) {
                ((DesignerAction)this.tools.get(i)).setChecked(true);
                continue;
            }
            ((DesignerAction)this.tools.get(i)).setChecked(false);
        }
    }
}

