/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qtjambi.properties;

import com.trolltech.qtjambi.QtJambiConnection;
import com.trolltech.qtjambi.QtJambiPlugin;
import com.trolltech.qtjambi.QtJambiPropertyPreferenceHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class QtJambiPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Button useWorkspaceSettings;
    private Composite composite;
    private IAdaptable adaptable;
    private IResource resource;
    private QtJambiPropertyPreferenceHelper helper = new QtJambiPropertyPreferenceHelper();

    private void init() {
        this.adaptable = this.getElement();
        if (this.adaptable != null) {
            if (this.adaptable instanceof IJavaProject) {
                this.resource = ((IJavaProject)this.getElement()).getResource();
            } else if (this.adaptable instanceof IProject) {
                this.resource = (IProject)this.getElement();
            }
        }
    }

    private String getValue(String string) {
        String string2 = "";
        try {
            string2 = this.resource.getPersistentProperty(new QualifiedName("", string));
        }
        catch (CoreException coreException) {
            QtJambiConnection.reportError((Exception)((Object)coreException), "Could not get property: " + string);
        }
        if (string2 == null || string2.equals("")) {
            return QtJambiPlugin.defaultValue(string);
        }
        return string2;
    }

    private void setValue(String string, String string2) {
        try {
            this.resource.setPersistentProperty(new QualifiedName("", string), string2);
        }
        catch (CoreException coreException) {
            QtJambiConnection.reportError((Exception)((Object)coreException), "Could not set property: " + string);
        }
    }

    private void enableChildren(Control[] controlArray, boolean bl) {
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            if (control == this.useWorkspaceSettings) continue;
            if (control instanceof Composite) {
                this.enableChildren(((Composite)control).getChildren(), bl);
            }
            control.setEnabled(bl);
        }
    }

    private void update() {
        this.enableChildren(this.composite.getChildren(), !this.useWorkspaceSettings.getSelection());
        boolean bl = !this.useWorkspaceSettings.getSelection();
        this.helper.juicDestinationFolderText.setEnabled(this.helper.juicUseDestinationFolder.getSelection() && bl);
        this.helper.juicCustomPrefixText.setEnabled(this.helper.juicUseCustomPrefix.getSelection() && bl);
    }

    protected Control createContents(Composite composite) {
        this.init();
        this.composite = new Composite(composite, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.useWorkspaceSettings = new Button(this.composite, 32);
        this.useWorkspaceSettings.setText("Use Workspace Settings");
        GridData gridData = new GridData();
        gridData.verticalAlignment = 2;
        this.useWorkspaceSettings.setLayoutData((Object)gridData);
        this.useWorkspaceSettings.setSelection(Boolean.parseBoolean(this.getValue("UseWorkspace")));
        this.useWorkspaceSettings.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                QtJambiPropertyPage.this.update();
            }
        });
        this.helper.addJambiSection(this.composite);
        boolean bl = Boolean.parseBoolean(this.getValue("JuicUseDestinationFolderProperty"));
        this.helper.juicDestinationFolderText.setText(this.getValue("JuicDestinationFolderProperty"));
        this.helper.juicUseDestinationFolder.setSelection(bl);
        boolean bl2 = Boolean.parseBoolean(this.getValue("JuicUseCustomPrefixProperty"));
        this.helper.juicCustomPrefixText.setText(this.getValue("JuicCustomPrefixProperty"));
        this.helper.juicUseCustomPrefix.setSelection(bl2);
        this.update();
        return this.composite;
    }

    public void performDefaults() {
        this.helper.performDefaults();
        this.useWorkspaceSettings.setSelection(Boolean.parseBoolean(QtJambiPlugin.defaultValue("UseWorkspace")));
        this.update();
    }

    public boolean performOk() {
        this.setValue("JuicDestinationFolderProperty", this.helper.juicDestinationFolderText.getText());
        this.setValue("JuicCustomPrefixProperty", this.helper.juicUseCustomPrefix.getText());
        this.setValue("JuicUseDestinationFolderProperty", this.helper.juicUseDestinationFolder.getSelection() + "");
        this.setValue("JuicUseCustomPrefixProperty", this.helper.juicUseCustomPrefix.getSelection() + "");
        this.setValue("JuicCustomPrefixProperty", this.helper.juicCustomPrefixText.getText() + "");
        this.setValue("UseWorkspace", this.useWorkspaceSettings.getSelection() + "");
        return true;
    }
}

