/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qtdesigner.editors;

import com.trolltech.qtdesigner.editors.DesignerActionBarContributor;
import com.trolltech.qtdesigner.views.FormWindowW;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Event;

public class DesignerAction
extends Action {
    private DesignerActionBarContributor contributor;
    private int actId;
    private boolean tool;
    private boolean hasicon;
    private int lastevent = 0;

    public DesignerAction(DesignerActionBarContributor designerActionBarContributor, int n, boolean bl) {
        this.actId = n;
        this.contributor = designerActionBarContributor;
        this.tool = bl;
        this.hasicon = false;
        FormWindowW formWindowW = designerActionBarContributor.activeEditor().formWindow();
        if (bl) {
            this.setText(formWindowW.toolName(n));
            String string = this.toolIconFile(n);
            if (string != null) {
                this.hasicon = true;
                try {
                    this.setImageDescriptor(ImageDescriptor.createFromFile(this.getClass(), (String)string));
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
            }
            this.setToolTipText(formWindowW.toolToolTip(n));
            this.setEnabled(true);
        } else {
            String string;
            this.setText(formWindowW.actionName(n));
            if (n > 6 && (string = this.actionIconFile(n)) != null) {
                this.hasicon = true;
                try {
                    this.setImageDescriptor(ImageDescriptor.createFromFile(this.getClass(), (String)string));
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
            }
            this.setToolTipText(formWindowW.actionToolTip(n));
            this.setEnabled(formWindowW.isEnabled(n));
        }
    }

    public void runWithEvent(Event event) {
        if (event.time != this.lastevent) {
            this.lastevent = event.time;
            this.run();
        }
    }

    public void run() {
        FormWindowW formWindowW = this.contributor.activeEditor().formWindow();
        if (this.tool) {
            formWindowW.setCurrentTool(this.actId);
            this.contributor.updateTools();
        } else {
            formWindowW.actionTrigger(this.actId);
        }
    }

    public boolean hasIcon() {
        return this.hasicon;
    }

    private String actionIconFile(int n) {
        switch (n) {
            case 7: {
                return "actionicons/editlower.png";
            }
            case 8: {
                return "actionicons/editraise.png";
            }
            case 9: {
                return "actionicons/edithlayout.png";
            }
            case 10: {
                return "actionicons/editvlayout.png";
            }
            case 11: {
                return "actionicons/edithlayoutsplit.png";
            }
            case 12: {
                return "actionicons/editvlayoutsplit.png";
            }
            case 13: {
                return "actionicons/editgrid.png";
            }
            case 14: {
                return "actionicons/editbreaklayout.png";
            }
            case 15: {
                return "actionicons/adjustsize.png";
            }
        }
        return null;
    }

    private String toolIconFile(int n) {
        switch (n) {
            case 0: {
                return "actionicons/widgettool.png";
            }
            case 1: {
                return "actionicons/signalslottool.png";
            }
            case 2: {
                return "actionicons/buddytool.png";
            }
            case 3: {
                return "actionicons/tabordertool.png";
            }
        }
        return null;
    }
}

