/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qtjambi.properties;

import com.trolltech.qtjambi.QtJambiConnection;
import com.trolltech.qtjambi.plugintest.QtJambiPluginTest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QtDesignerPlugins
extends PropertyPage {
    private IProject project;
    private File file;
    private Button[] buttons;
    private Vector<QtJambiPluginTest> tests = new Vector();

    private void init() {
        Object object;
        this.project = (IProject)this.getElement().getAdapter(IProject.class);
        this.file = new File(this.project.getFile("plugins/qtjambi/designer.xml").getLocationURI());
        IJavaProject iJavaProject = JavaCore.create((IProject)this.project);
        IProject iProject = null;
        try {
            object = iJavaProject.getOutputLocation();
            iProject = this.project.getWorkspace().getRoot().getFolder((IPath)object);
        }
        catch (Exception exception) {
            iProject = this.project;
        }
        object = this.findJavaFiles((IContainer)iProject);
        Iterator iterator = ((Vector)object).iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            QtJambiPluginTest qtJambiPluginTest = new QtJambiPluginTest(iResource, (IResource)iProject);
            this.tests.add(qtJambiPluginTest);
        }
    }

    private Vector<IResource> findJavaFiles(IContainer iContainer) {
        Vector<IResource> vector = new Vector<IResource>();
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iContainer.members();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        if (iResourceArray != null) {
            for (int i = 0; i < iResourceArray.length; ++i) {
                IResource iResource = iResourceArray[i];
                if (iResource.getType() == 1 && iResource.getName().endsWith(".class")) {
                    vector.add(iResource);
                    continue;
                }
                if (!(iResource instanceof IContainer)) continue;
                vector.addAll(this.findJavaFiles((IContainer)iResource));
            }
        }
        return vector;
    }

    protected Control createContents(Composite composite) {
        this.init();
        Table table = new Table(composite, 2050);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        Object object = new TableColumn(table, 0);
        object.setWidth(300);
        object.setText("Class");
        object = new TableColumn(table, 0);
        object.setText("Found");
        object.pack();
        object = new TableColumn(table, 0);
        object.setText("Subclass");
        object.pack();
        object = new TableColumn(table, 0);
        object.setText("Constructor");
        object.pack();
        object = new TableColumn(table, 0);
        object.setText("Enable plugin");
        object.pack();
        object = this.getEnabledPlugins(this.file);
        this.buttons = new Button[this.tests.size()];
        for (int i = 0; this.tests.size() > i; ++i) {
            Button button;
            int n = 0;
            QtJambiPluginTest qtJambiPluginTest = this.tests.elementAt(i);
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setText(n++, qtJambiPluginTest.getName());
            tableItem.setText(n++, qtJambiPluginTest.checkedClassOk() ? "OK" : "");
            tableItem.setText(n++, qtJambiPluginTest.checkedSubclassOk() ? "OK" : "");
            tableItem.setText(n++, qtJambiPluginTest.checkedConstructorOk() ? "OK" : "");
            this.buttons[i] = button = new Button((Composite)table, 32);
            button.setSelection(object.contains(qtJambiPluginTest.getName()) && qtJambiPluginTest.sucsess());
            button.setEnabled(qtJambiPluginTest.sucsess());
            button.pack();
            TableEditor tableEditor = new TableEditor(table);
            tableEditor.minimumWidth = button.getSize().x;
            tableEditor.horizontalAlignment = 16384;
            tableEditor.setEditor((Control)button, tableItem, n++);
            tableEditor.layout();
        }
        return table;
    }

    public boolean performOk() {
        try {
            this.file.getParentFile().mkdirs();
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            outputStreamWriter.write("<qt-jambi-custom-widget-list>\n");
            for (int i = 0; this.tests.size() > i; ++i) {
                if (!this.tests.elementAt(i).sucsess() || !this.buttons[i].getSelection()) continue;
                outputStreamWriter.write("    <qt-jambi-custom-widget\n");
                outputStreamWriter.write("        class=\"" + this.tests.elementAt(i).getName() + "\"\n");
                outputStreamWriter.write("        group=\"" + this.project.getName() + "\"\n");
                outputStreamWriter.write("    />\n");
            }
            outputStreamWriter.write("</qt-jambi-custom-widget-list>\n");
            outputStreamWriter.close();
            QtJambiConnection.updateWidgetBox(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private Set<String> getEnabledPlugins(File file) {
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            object = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = new HashSet();
        if (document != null) {
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("qt-jambi-custom-widget")) continue;
                object.add(node.getAttributes().getNamedItem("class").getNodeValue());
            }
        }
        return object;
    }
}

