/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qtjambi.wizards.pages;

import com.trolltech.common.QtWizardUtils;
import com.trolltech.qtjambi.wizards.pages.QtWizardPage;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class FormWizardPage
extends NewTypeWizardPage
implements QtWizardPage {
    private Tree tree;
    private Label preview;

    public FormWizardPage() {
        super(true, FormWizardPage.class.getCanonicalName());
    }

    public void init(IStructuredSelection iStructuredSelection) {
        IJavaElement iJavaElement = this.getInitialJavaElement(iStructuredSelection);
        this.initContainerPage(iJavaElement);
        this.initTypePage(iJavaElement);
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] iStatusArray = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.doUIFormTypeUpdates();
        this.updateStatus(iStatusArray);
    }

    protected void handleFieldChanged(String string) {
        super.handleFieldChanged(string);
        this.doStatusUpdate();
    }

    protected void createUIFormTypeControls(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = n;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.tree = new Tree(composite2, 2048);
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                FormWizardPage.this.doStatusUpdate();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                FormWizardPage.this.doStatusUpdate();
            }
        });
        this.tree.setLayoutData((Object)new GridData(0, 4, false, false));
        this.preview = new Label(composite2, 0);
        this.preview.setLayoutData((Object)new GridData(4, 4, true, true));
        QtWizardUtils.setupTemplates((Object)this, (String)"com/trolltech/qtjambi/templates", (String)"templates.txt", (Tree)this.tree);
        this.doStatusUpdate();
    }

    protected void doUIFormTypeUpdates() {
        if (this.preview == null) {
            return;
        }
        Image image = null;
        try {
            String string = this.tree.getSelection()[0].getData() + ".png";
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
            image = new Image((Device)this.preview.getDisplay(), inputStream);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.preview.setImage(image);
        this.preview.pack();
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        int n = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        this.createContainerControls(composite2, n);
        this.createPackageControls(composite2, n);
        this.createSeparator(composite2, n);
        this.createTypeNameControls(composite2, n);
        this.createSeparator(composite2, n);
        this.createUIFormTypeControls(composite2, n);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.tree.getSelectionCount() > 0;
    }

    public String getPathToTemplate() {
        return this.tree.getSelection()[0].getData() + ".jui";
    }

    public void after(IProgressMonitor iProgressMonitor) {
    }

    public void before(IProgressMonitor iProgressMonitor) {
    }

    public void current(IProgressMonitor iProgressMonitor) {
    }
}

