/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qtjambi.plugintest;

import com.trolltech.qtjambi.QtJambiConnection;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class QtJambiPluginTest {
    private boolean checkClass = false;
    private boolean checkSubclass = false;
    private boolean checkConstructor = false;
    private String name = "";

    public QtJambiPluginTest(IResource iResource, IResource iResource2) {
        Object object;
        URL[] uRLArray = new URL[]{};
        try {
            int n;
            object = iResource.getProjectRelativePath().segments();
            String[] stringArray = iResource2.getProjectRelativePath().segments();
            for (int i = stringArray.length; i < ((String[])object).length - 1; ++i) {
                this.name = this.name + object[i] + ".";
            }
            this.name = this.name + object[((String[])object).length - 1].substring(0, object[((String[])object).length - 1].indexOf("."));
            IJavaProject iJavaProject = JavaCore.create((IProject)iResource.getProject());
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getResolvedClasspath(true);
            ArrayList<URL> arrayList = new ArrayList<URL>();
            String string = iResource2.getLocationURI().getRawPath();
            String string2 = Platform.getOS();
            if (string2.equals("win32") && string.startsWith("/")) {
                string = string.substring(1);
            }
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            arrayList.add(new URI("file:" + string).toURL());
            for (n = 0; n < iClasspathEntryArray.length; ++n) {
                if (iClasspathEntryArray[n].getEntryKind() == 3) continue;
                arrayList.add(new URL("file:" + iClasspathEntryArray[n].getPath().toString()));
            }
            uRLArray = new URL[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                uRLArray[n] = (URL)arrayList.get(n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = null;
        try {
            object = this.loadClass(this.name, uRLArray);
        }
        catch (Exception exception) {
            QtJambiConnection.reportError(exception, "Exception when loading from output directory");
        }
        this.checkClass = object != null;
        this.checkSubclass = this.checkClass((Class)object);
        this.checkConstructor = this.checkConstructor((Class)object);
    }

    private Class loadClass(String string, URL[] uRLArray) {
        Class<?> clazz = null;
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
        try {
            clazz = uRLClassLoader.loadClass(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return clazz;
    }

    private boolean checkClass(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.getName().equals("com.trolltech.qt.gui.QWidget")) {
            return true;
        }
        return this.checkClass(clazz.getSuperclass());
    }

    private boolean checkConstructor(Class clazz) {
        if (clazz == null) {
            return false;
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length != 1 || classArray[0] == null || !classArray[0].getName().equals("com.trolltech.qt.gui.QWidget")) continue;
            return true;
        }
        return false;
    }

    public boolean checkedClassOk() {
        return this.checkClass;
    }

    public boolean checkedConstructorOk() {
        return this.checkConstructor;
    }

    public boolean checkedSubclassOk() {
        return this.checkSubclass;
    }

    public String getName() {
        return this.name;
    }

    public boolean sucsess() {
        return this.checkClass && this.checkConstructor && this.checkSubclass;
    }

    public String toString() {
        String string = "Result for : " + this.name + "\n";
        string = string + "  Class test OK:       " + this.checkClass + "\n";
        string = string + "  Subclass test OK:    " + this.checkSubclass + "\n";
        string = string + "  Constructor test OK: " + this.checkConstructor + "\n";
        return string;
    }
}

