/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/*	       codice non ansi per XENIX & UNIX	*/
/* file clos_ux1.c */

#include <sys/types.h>
#include <sys/timeb.h>
#include <signal.h>
#include "clos.h"
#include "closerr.h"
#include "closnans.h"

void disp();

int clos_non_ansi_init()
{
 signal(SIGINT,disp);
  printf("\n\n\n");		        		
 printf(
" ------------------>   Common Lisp Object System   V%s <------------------ \n",CLOS_VERSION);
						/*   05  */
 printf(
"----------------> (c) 1991--1994 By Andrea Michele Zoia <----------------------\n");
         
 printf(
"------------------------------>  For Xenix  <----------------------------------\n");
 return OK;
}

void disp(par)
int par;
{
 signal(SIGINT,disp);
 longjmp(critical_jmp,LONGJMP_CONTROLC);
}


void clos_non_ansi_exit()
{
 exit(0);
}

int cl_beep(freq)
int freq;
{
 return OK;
}

int cl_getch()
{
 return 13;
}

long na_millitime()
{
 /* ritorna il timer in millisecondi */
 struct timeb t;
 long tmp;

 ftime(&t);

 tmp=t.time;
 tmp*=1000;
 tmp+=(long)t.millitm;
 return tmp;
}


char *matherr_names[6]={
	"DOMAIN",
	"SINGgularity",
	"OVERFLOW",
	"UNDERFLOW",
	"Total LOSS of precision",
	"Partial LOSS of precision"
};
int matherr(e)
struct exception *e;
{
 char buffer[200];
 sprintf(buffer,
	"type<%s>,function name<%s>,argument1<%f>,argument2(zero if nonexistent)<%f>",
	matherr_names[e->type-1],e->name,e->arg1,e->arg2
 );
 error(E_MATH,ERR_MERROR|ERR_PSTRING|ERR_TBLVL,buffer);
 return 1;
}


void stack_backtrace()
{
}



/*****************   EMULAZIONE TERMINALE ***************/
/* put_char, put_string, get_char, get_string, curpos	*/
/********************************************************/

int lisp_curpos(x,y)
int x;
int y;
{
 if(x>=1 && x<=80 && y>=1 && y<=25)
   printf("%c[%u;%uf",27,26-y,x);
}

int lisp_charcolor(fore,back,attrib)
n_int fore;
n_int back;
n_int attrib;
{
 if(attrib>=1 && attrib <=9)
   printf("%c[%um",27,(int)(attrib-1));
 if(back>=1 && back <=8)
   printf("%c[%um",27,(int)(39+back));
 if(fore>=1 && fore <=8)
   printf("%c[%um",27,(int)(29+fore));

}
int lisp_cls()
{
 printf("%c[2J",27);
 printf("%c[%u;%uf",27,24,0);
}

int lisp_put_char(c,f)
int c;
FILE *f;
{
 /* ritorna c oppure EOF se c'e' qualche errore */
 if(f==stdout || f==stderr){
   if(dribble_file)fputc(c,dribble_file);
 }
 return f?fputc(c,f):EOF;
}

int lisp_print_string(s,f)
char *s;
FILE *f;
{
 /* ritorna l'ultimo carattere della stringa oppure EOF se c'e' un errore */
 int ret;
 while(*s)ret=lisp_put_char(*s++,f);
 return ret;
}


int lisp_get_char(f)
FILE *f;
{
 int c;
 c=f?getc(f):EOF;
 if(f==stdin && c!=EOF && dribble_file)
   fputc(c,dribble_file);
 return c;
}

int lisp_get_string(c,len,f)
char *c;
int len;
FILE *f;
{
 /* len e' la lunghezza massima della stringa senza lo zero finale */
 /* ritorna una stringa senza il newline finale */

 if(!f)return EOF;
 if(!fgets(c,len+1,f))return EOF;
 while(*c)c++;
 if(*--c=='\n'){
   *c=0;
 }else{
   if(f==stdin){
     /* svuota il buffer della tastiera */
     while(1){
       switch(fgetc(f)){
	 case '\n':break;
	 case EOF: return EOF;
	 default: continue;
       }
       break;
     }
   }
 }
 if(f==stdin && dribble_file)
   fputs(c,dribble_file);
 return len;
}

