// $Id: DBugFrame.java,v 1.1 1997/10/14 15:37:55 xzhu Exp $
// DBugFrame.java
//
// Debug Frame 
// 
// Author: Xiaokun Kelvin ZHU
// Address: kelvin@iname.com
// 1997, 10, 12
// Version 1.1

// Copyright (C) 1997, X.K.ZHU
//   The `DBug.java' is free software and comes with NO WARRANTY of any
//   kind; you can redistribute it and/or modify it under the terms of the 
//   GNU Library General Public License as published by the Free Software 
//   Foundation; either version 2 of the License, or (at your option) any 
//   later version.

package zxk.util;

import java.io.Serializable;
import java.util.*;

public class DBugFrame implements Serializable
{
  private String funcName; // func name
  private String className; // class name
  private int level; // level
  private Stack funcS; // func name stack
  private Stack classS; // class name stack
  private Stack levelS; // level value stack

  /** 
   * Default constructor
   */
  public 
  DBugFrame()
  {
    funcName = null;
    className = null;
    level = 0;
    funcS = new Stack();
    classS = new Stack();
    levelS = new Stack();
  }

  /** 
   * Constructor with func name, class name, and level value
   * @param funcName func name
   * @param className class name
   * @param level frame level value
   */
  public 
  DBugFrame(String funcName, String className, int level)
  {
    this();
    pushFuncName(funcName);
    pushClassName(className);
    pushLevel(level);
  }

  /** Set func name
   * @param funcName func name
   */
  private void
  setFuncName(String funcName)
  {
    this.funcName = funcName;
  }
 
  /** Get func name
   * @return func name
   */
  public String
  getFuncName()
  {
    return funcName;
  }

  /** Set class name
   * @param className class name
   */
  private void
  setClassName(String className)
  {
    this.className = className;
  }
 
  /** Get classfunc name
   * @return classfunc name
   */
  public String
  getClassName()
  {
    return className;
  }

  /** Set frame level value
   * @param level frame level value
   */
  private void
  setLevel(int level)
  {
    this.level = level;
  }
 
  /** Get frame level value
   * @return frame level value
   */
  public int
  getLevel()
  {
    return level;
  }

  /** push func name
   * @param funcName func name
   */
  public void
  pushFuncName(String funcName)
  {
    this.funcName = funcName;
    funcS.push(funcName);
  }

  /** push class name
   * @param className class name
   */
  public void
  pushClassName(String className)
  {
    this.className = className;
    classS.push(className);
  }

  /** push level value
   * @param level
   */
  public void
  pushLevel(int level)
  {
    this.level = level;
    levelS.push(new Integer(level));
  }

  /** pop func name
   * @return  func name
   */
  public String
  popFuncName()
  {
    funcS.pop();
    funcName = (String)funcS.peek();
    return funcName;
  }

  /** pop class name
   * @return  class name
   */
  public String
  popClassName()
  {
    classS.pop();
    className = (String)classS.peek();
    return className;
  }

  /** pop level value
   * @return  level value
   */
  public int
  popLevel()
  {
    levelS.pop();
    level = ((Integer)levelS.peek()).intValue();
    return level;
  }
}
