// $Id: gweMysqlDriver.java,v 1.8 1997/11/11 11:39:42 xzhu Exp $
//////////////////////////////////////////////////////////////////
// mysql JDBC Driver
//
// Version : 0.9.3
//
// JDBC : 1.22
//
// LastModified: 12.03.1997
//
// Copyright (c) 1997 GWE Technologies Ltd. All rights reserved
// See http://gwe.co.uk/mysql/jdbc/copyright.html for full details

package gwe.sql;

import java.sql.*;
import java.util.*;


public class gweMysqlDriver implements java.sql.Driver {
  static {
    try {
      new gweMysqlDriver();
    }
    catch( SQLException e ) {
      e.printStackTrace();
    }
  }
  
  /**
   * Constructs a new driver and registers it with
   * java.sql.DriverManager.registerDriver() as specified by the JDBC
   * draft protocol.
   */
  public gweMysqlDriver() throws SQLException {
    java.sql.DriverManager.registerDriver(this);
  }

  /**
   * Takes a look at the given URL to see if it is meant for this
   * driver.  If not, simply return null.  If it is, then go ahead and
   * connect to the database.  For the mysql implementation of JDBC, it
   * looks for URL's in the form of <P>
   * <PRE>
   *     jdbc:mysql://[host_addr]:[port]/[db_name]
   *	 jdbc:mysql:db_name
   *	 "jdbc:mysql://[host_addr]:[port]/[db_name]?user=xxx;password=xxx;command=xxx xxxx"
   * </PRE>
   * @see java.sql.Driver#connect
   * @param url the URL for the database in question
   * @param info the properties object
   * @return null if the URL should be ignored, a new Connection
   * implementation if the URL is a valid mysql URL
   */
  public Connection connect(String url, Properties info)
       throws SQLException {
    String host, database, tmp;
    int i, j, port, len = url.length();
    
    if( len < 8 ) return null;
    tmp = url.substring(5, 10);
    if( !tmp.equals("mysql") ) return null;
    i = url.indexOf(':', 12);
    if( i == -1 ) {
      j = url.indexOf('/', 13);
      if (j < 13)
      {
        host = new String("localhost");
        j = 10; // jdbc:mysql:
      }
      else
        host = url.substring(13, j);
      port = 3333;
    } else if( len < (i+2) ) {
      throw new SQLException("Invalid URL: URL must specify a connect port.");
    } else {
      host = url.substring(13, i++);
      j = url.indexOf('/', i);
      tmp = url.substring(i, j);
      try {
		 port = Integer.valueOf(tmp).intValue();
      }
      catch( NumberFormatException e ) {
		throw new SQLException("Invalid port in URL: " + e.getMessage());
      }
    }
    String user = info.getProperty("user");
    String password = info.getProperty("password");
    String command = new String("initdb");
    String extra = null;
    String s = url.substring(j+1);
    i = s.indexOf('?');
    if (i == -1)
      database = s;
    else
    {
      database = s.substring(0, i);
      s = s.substring(i+1);
      StringTokenizer st = new StringTokenizer(s, ";");
      while (st.hasMoreTokens())
      {
        String token = st.nextToken();
        i = token.indexOf('=');
        if (i == -1)
          continue;
        String cmd = token.substring(0, i);
        String val = token.substring(i+1);
	if (cmd.equals("user"))
	{
	  if (user == null || user.length() == 0)
	    user =  val;
	}
        else if (cmd.equals("password"))
	{
	  if (password == null || password.length() == 0)
	    password  = val;
	}
	else if (cmd.equals("command"))
	{
	  int k = val.indexOf(' ');
	  if (k==-1)
	  {
	    command = val;
	  }
	  else
	  {
	    command = val.substring(0,k);
	    database = val.substring(k+1); // only for "kill" command
	  }
	} // end if "command"
	else if (cmd.equals("clientparam"))
	{
	  extra = val;
	}
      }
    }
//System.out.println("User:"+user+",Password:"+password+ ",Command:"+command+",extra:"+extra);
    return new gweMysqlConnection(host, port, user, password, database, 
      url, this, command, extra);
  }

  /**
   * Returns true if the driver thinks that it can open a connection
   * to the given URL.  Typically drivers will return true if they
   * understand the sub-protocol specified in the URL and false otherwise.
   *
   * @param url The URL of the database.
   * @return True if this driver can connect to the given URL.
   */
  public boolean acceptsURL(String url) throws SQLException {
    if( url.length() < 11 ) return false;
    return url.substring(5,10).equals("mysql");
  }

  /**
   * <p>The getPropertyInfo method is intended to allow a generic GUI tool to\

   * discover what properties it should prompt a human for in order to get
   * enough information to connect to a database.  Note that depending on
   * the values the human has supplied so far, additional values may become
   * necessary, so it may be necessary to iterate though several calls
   * to getPropertyInfo.
   *
   * @param url The URL of the database to connect to.
   * @param info A proposed list of tag/value pairs that will be sent on
   *          connect open.
   * @return An array of DriverPropertyInfo objects describing possible
   *          properties.  This array may be an empty array if no properties
   *          are required.
   */
  public DriverPropertyInfo[] getPropertyInfo(String url,
					      java.util.Properties info)
       throws SQLException {
    return new DriverPropertyInfo[0];
  }
				
  /**
   * Gives the major version for this driver as required by the JDBC
   * draft specification.
   * @see java.sql.Driver#getMajorVersion
   * @return the major version
   */
  public int getMajorVersion() {
    return 0;
  }

  /**
   * Gives the minor version for this driver as required by the JDBC
   * draft specification.
   * @see java.sql.Driver#getMinorVersion
   * @return the minor version
   */
  public int getMinorVersion() {
    return 93;
  }

  /**
   * Returns information noting the fact that the mysql database is not
   * fully SQL-92 and thus cannot support a JDBC compliant implementation.
   */
  public boolean jdbcCompliant() {
    return false;
  }
}
