// $Id: gweMysqlConnection.java,v 1.11 1997/11/25 21:21:16 xzhu Exp $
//////////////////////////////////////////////////////////////////
// mysql JDBC Driver
//
// Version : 0.9.2
//
// JDBC : 1.22
//
// LastModified: 12.03.1997
//
// Copyright (c) 1997 GWE Technologies Ltd. All rights reserved
// See http://gwe.co.uk/mysql/jdbc/copyright.html for full details

package gwe.sql;

import java.sql.*;
import gwe.sql.gweMysql;

public class gweMysqlConnection implements java.sql.Connection {

  private gweMysql mysql = null;
  /**
   * The JDBC driver for this connection
   */
  private Driver driver;
  /**
   * The URL for this connection
   */
  /**
   * Catalog string 
   */
  private String catalog;
  /**
   * Transaction isolation level
   */
  private int isolation;
  
  /**
   * Connects to the mysql server
   * @exception SQLException raised in the event of connection failure
   * @param host the IP address of the host on which the mysql server resides
   * @param root true if this is a root connection, false if otherwise
   * @param database the database to which a connection should be made
   * @param u the URL used to connect to this database
   * @param d the driver that instantiated this connection
   */
  public gweMysqlConnection(String host, int port, String user, 
      String password, String database, String u, Driver d, 
      String command, String extra) 
      throws SQLException 
    {
  	
    if ( user == null || user == "" ) 
      user = "nobody";
    try {
      mysql = new gweMysql();
      mysql.Connect(host, port, database, user, password, extra);
      mysql.urlCommand(command, database);
    }
    catch( SQLException e ) {
      mysql = null;
      throw new SQLException("mysql exception: " + e.getMessage());
    }
    driver = d;
  }
  
  /**
   * JDBC draft specification method for returning a SQL statement
   * object.
   * @see java.sql.Connection#createStatement
   * @exception SQLException thrown in the event the creation fails
   * @return a new statement object
   */
  public Statement createStatement() throws SQLException {
    return new gweMysqlStatement(this);
  }
	
  /**
   * JDBC draft specification method for returning an SQL pre-compiled
   * statement.  Note that mysql does not support such things, so this
   * thing just throws an exception.
   * @see java.sql.Connection#prepareStatement
   * @exception SQLException gets thrown any time this is called
   */
  public PreparedStatement prepareStatement(String sql) throws SQLException {
    return new kfnMysqlPreparedStatement(this, sql);
    //throw new SQLException("mysql does not support prepared statements.");
  }

  /**
   * JDBC draft specification method for creating a stored procedure call.
   * Note that mysql does not support stored procedures, so this method
   * throws an exception.
   * @see java.sql.Connection#prepareCall
   * @exception SQLException gets thrown any time this is called
   */
  public CallableStatement prepareCall(String sql)
       throws SQLException {
    throw new SQLException("mysql does not support stored procedures.");
  }

  /**
   * We do not currently try to map SQL-92 to mysql :-)
   * @see java.sql.Connection#nativeSQL
   * @param sql the query which just gets thrown right back out
   * @return the SQL string
   */
  public String nativeSQL(String sql) throws SQLException {
    return sql;
  }

  /**
   * JDBC 1.0 specification method for returning the auto-close
   * status of the connection.
   * @return true
   */
  public boolean getAutoClose() throws SQLException {
    return true;
  }

  /**
   * JDBC 1.0 specification method for setting auto-close.  
   * @param b meaningless
   */
  public void setAutoClose(boolean b) throws SQLException {
  }
  
  /**
   * JDBC 1.0 specification method for determining the
   * auto-commit state of the connection.
   * @see java.sql.Connection#getAutoCommit
   */
  public boolean getAutoCommit() throws SQLException {
    return true;
  }
  
  /**
   * JDBC 1.0  specification method for setting auto-commit.  Since
   * mysql has no transaction management, this connection object acts
   * exactly as if auto-commit were set.  So this method does nothing.
   * @see java.sql.Connection#setAutoCommit
   * @param b throw an exception if this is false
   */
  public void setAutoCommit(boolean b) throws SQLException {
    if( b ) return;
    throw new SQLException("mysql must always be auto-commit = true.");
  }

  /**
   * JDBC draft specification method for committing a transaction. 
   * @see java.sql.Connection#commit
   */
  public void commit() throws SQLException {
  }

  /**
   * JDBC draft specification method for rolling back a transaction.  Since
   * mysql has no support for rollbacks, this method throws an exception.
   * @see java.sql.Connection#rollback
   * @exception SQLException gets thrown if this ever gets called
   */
  public void rollback() throws SQLException {
    throw new SQLException("mysql does not support rollbacks.");
  }

  /**
   * JDBC draft specification method for closing the database connection.
   * @see java.sql.Connection#close
   * @exception SQLException thrown in the event of a SQLException
   */
  public void close() throws SQLException {
    try {
      mysql.Close();
      mysql = null;
    }
    catch( SQLException e ) {
      throw new SQLException("mysql exception: " + e.getMessage());
    }
  }

  /**
   * JDBC draft specification method for letting others know the connection
   * status.
   * @see java.sql.Connection#isClosed
   * @exception SQLException who knows why Sun thought this needed an exception
   * @return true if the connection is closed, false otherwise
   */
  public boolean isClosed() throws SQLException {
    return (mysql == null);
  }

  /**
   * JDBC draft specification method to return information about
   * the database. This is yet to be written.
   * @see java.sql.Connection#getMetData
   * @exception SQLException thrown if an error occurs reading meta-data
   * @return a DatabaseMetaData object with database info
   */
  public DatabaseMetaData getMetaData()
       throws SQLException {
    return new gweMysqlDatabaseMetaData(this);
  }

  /**
   * JDBC draft specification method to put the connection in read-only mode.
   * @see java.sql.Connection#setReadOnly
   * @param b boolean read only
   */
  public void setReadOnly(boolean b) throws SQLException {
  }

  /**
   * JDBC draft specification method to return the read-only status of the
   * connection.  Since mysql has no such status, this always returns false.
   * @see java.sql.Connection#isReadOnly
   * @return always false
   */
  public boolean isReadOnly() throws SQLException {
    return false;
  }

  /**
   * JDBC draft specification method to select a sub-space of the target
   * database.  It basically has no menaing to mysql.
   * @see java.sql.Connection#setCatalog
   * @param str the catalog
   */
  public void setCatalog(String str) throws SQLException {
    catalog = str;
  }

  /**
   * JDBC draft specification method to return the catalog.  This has no
   * meaning to mysql.
   * @see java.sql.Connection#getCatalog
   * @return the catalog name
   */
  public String getCatalog() throws SQLException {
    return catalog;
  }

  /**
   * JDBC draft specification method for setting the transaction isolation
   * level for the connection.  This has no meaning to mysql.
   * @see java.sql.Connection#setTransactionIsolation
   * @param x the isolation level
   */
  public void setTransactionIsolation(int x)
       throws SQLException {
    isolation = x;
  }

  /**
   * JDBC draft specification method for retrieving the transaction
   * isolation level for the connection.  This information has no meaning
   * to mysql.
   * @see java.sql.Connection#getTransactionIsolation
   * @return the transaction isolation level
   */
  public int getTransactionIsolation() throws SQLException {
    return isolation;
  }

  /**
   * JDBC draft specification method for disabling of closing of statements
   * and result sets.  This has no meaning to mysql.
   * @see java.sql.Connection#disableAutoClose
   */
  public void disableAutoClose() throws SQLException {
  }

  /**
   * JDBC draft specification method for retrieving a chain of warnings
   * related to the connection.
   * @see java.sql.Connection#getWarnings
   * @return the chain of warnings for this connection
   */
  public SQLWarning getWarnings() throws SQLException {
    return mysql.getWarnings();
  }

  /**
   * JDBC draft specification method for clearing the warning chain.
   * @see java.sql.Connection#clearWarnings
   */
  public void clearWarnings() throws SQLException {
    mysql.clearWarnings();
  }

  /**
   * Executes an SQL Query statement.
   * @param sql the statement to be executed
   * @return results of the statement
   */
  public gweMysql executeQuery(String sql) throws SQLException {
    gweMysql result;
    try {
      result = mysql.sqlQuery(sql);
    }
    catch( SQLException e ) {
      throw new SQLException("mysql exception: " + e.getMessage());
    }
    return result;
  }
  
  public String getHost()
  {
    return mysql.getHost();
  }

  public int getPort()
  {
    return mysql.getPort();
  }

  public String getDbName()
  {
    return mysql.getDbName();
  }

  public String getUser()
  {
    return mysql.getUser();
  }

  public int getMajorVersion()
  {
    return driver.getMajorVersion();
  }

  public int getMinorVersion()
  {
    return driver.getMinorVersion();
  }

  public String getDbVersion()
  {
    return mysql.getDbVersion();
  }

  public void closeResultSet()
    throws SQLException
  {
    try
    {
      mysql.closeResultSet();
    } catch (SQLException e)
    { throw e; }
  }
}
