/*
**  process.h           ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**			P.O. BOX 79
**			Kingston, MA. 02364
**			(508) 746 - 7341 Voice
**			(508) 746 - 4678 FAX
**			e-mail uunet!microway!mark
**			       mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _PROCESS_H
#define _PROCESS_H

#ifndef _OS_H

/* mode values for spawn- routines */
#define P_WAIT          0
#define P_NOWAIT        1
#define P_OVERLAY       2

#define WAIT_CHILD 0
#define WAIT_GRANDCHILD 1

#endif /* _OS_H */


#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__                 /* C++ */
   extern "C" {
#endif

void      abort(void);
void     _exit(int _Status);
void      exit(int status_);
int       getpid(void);
int       spawnl(int _Modeflag, char *_Path, char *_Arg0,...);
int       spawnle(int _Modeflag, char *_Path, char *_Arg0,...);
int       spawnlp(int _Modeflag, char *_Name, char *_Arg0,...);
int       spawnlpe(int _Modeflag, char *_Name, char *_Arg0,...);
int       spawnv(int _Modeflag, char *_Path, char **_Args);
int       spawnve(int _Modeflag, char *_Path, char **_Args, char **_Envp);
int       spawnvp(int _Modeflag, char *_Name, char **_Args);
int       spawnvpe(int _Modeflag, char *_Name, char **_Args, char **_Envp);
int       system(const char *_String);

#ifdef __NDPX__         /* C++ */
   }
#endif

#else /* K&R */

void      abort();
void     _exit();
void      exit();
int       getpid();
int       spawnl();
int       spawnle();
int       spawnlp();
int       spawnlpe();
int       spawnv();
int       spawnve();
int       spawnvp();
int       spawnvpe();
int       system();

#endif /* __STDC__ || __NDPX__ */

#endif /* _PROCESS_H */
