/*
**  os.h                ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _OS_H
#define _OS_H

/* Needed for typedefs and function declarations */
#include <stdio.h>
#include <stdlib.h>

#ifndef _TIME_T
#define _TIME_T
typedef unsigned long time_t;
#endif

/* Typedefs for i860 dependent return values */

#ifndef __TDEFS
#define __TDEFS

#ifdef __i860

typedef void _int;
typedef void _unsigned;
typedef int  _pchar;
typedef int  _pvoid;

#else

typedef int      _int;
typedef unsigned _unsigned;
typedef char *   _pchar;
typedef void *   _pvoid;

#endif /* __i860 */

#endif /* __TDEFS */

/* Character constants */
#define NEWLINE      '\n'
#define TAB          '\t'
#define RETURN       '\r'
#define BACKSLASH    '\\'
#define BACKSPACE    '\b'
#define FORMFEED     '\f'
#define SINGLEQUOTE  '\''
#define DOUBLEQUOTE  '\"'
#define EOS          '\0'
#define NUL          EOS
#define SOH          01
#define STX          02
#define ETX          03
#define ACK          06
#define BELL         07
#define EOL          '\n'
#define SUB          032
#define ESC          033

/* constants for _split_path */
#ifdef __SYSV__

#define _MAX_PATH	2048
#define _MAX_DRIVE	  14 
#define _MAX_DIR	2048
#define _MAX_FNAME	  14
#define _MAX_EXT	  14	

#elif defined(__MSDOS__)

#define _MAX_PATH	 80
#define _MAX_DRIVE	  3
#define _MAX_DIR	 64
#define _MAX_FNAME	 13
#define _MAX_EXT	  4

#else

#define _MAX_PATH	260
#define _MAX_DRIVE	  3
#define _MAX_DIR	256
#define _MAX_FNAME	256
#define _MAX_EXT	256

#endif

/* Character handling macros */
#include <ctype.h>

#ifndef _tolower
#define _tolower(_Ch) ((_Ch)+('a'-'A'))
#endif
#ifndef _toupper
#define _toupper(_Ch) ((_Ch)-('a'-'A'))
#endif
#ifndef isascii
#define isascii(_Ch)  ((unsigned)(_Ch)<=0x7f)
#endif
#ifndef toascii
#define toascii(_Ch)  ((_Ch)&0x7f)
#endif
#ifndef iscntl
#define iscntl(_Ch)   (((_Ctype)[(_Ch)])&(_CONTROL))
#endif
#ifndef iscsym
#define iscsym(_Ch)   (_Ch == '_' || (((_Ctype)[(_Ch)])&(_UPPER|_LOWER|_DIGIT)))
#endif
#ifndef iscsymf
#define iscsymf(_Ch)  (_Ch == '_' || (((_Ctype)[(_Ch)])&(_UPPER|_LOWER)))
#endif

#define fgetchar()   fgetc(stdin)
#define fputchar(_Ch) fputc(_Ch, stdout)
#define min(_A,_B)     (((_A) < (_B))? (_A) : (_B))
#define max(_A,_B)     (((_A) > (_B))? (_A) : (_B))
#define onexit(_A)    atexit(_A)
#ifndef fileno
#define fileno(_Fp)   ((_Fp)->_Fd)
#endif

/* constants for dos_findfirst */
#define _A_NORMAL   0x00
#define _A_RDONLY   0x01
#define _A_HIDDEN   0x02
#define _A_SYSTEM   0x04
#define _A_VOLID    0x08
#define _A_SUBDIR   0x10
#define _A_ARCH     0x20

#define PI      3.14159265358979323846

extern int signgam; /* For gamma() */

/* The Windows NT header winsock.h defines its own timeval. If under Windows
   NT, use its definition instead.
*/
#ifndef __WIN32__
struct timeval {    /* Time since epoch. */
        int tv_sec;    /* Seconds. */
        int tv_usec;   /* Microseconds. */
        };
#endif

struct timezone {    /* Timezone ID. */
        char    name[3];
        };


#ifndef _EXTERR_H

/* Extended error information */
extern int ext_error;
#define EXNOERR 00  /* no error */
#define EXFUNCT 01  /* Invalid service function */
#define EXFNF   02  /* file not found */
#define EXPNF   03  /* path not found */
#define EXFILES 04  /* too many open files */
#define EXACCES 05  /* access denied */
#define EXHANDL 06  /* invalid file handle */
#define EXMEMC  07  /* memory control blocks corrupt */
#define EXNOMEM 08  /* not enough RAM */
#define EXADDR  09  /* invalid address */
#define EXENV   10  /* environment error */
#define EXFRMT  11  /* invalid format */
#define EXACODE 12  /* access code error */
#define EXDATA  13  /* data error */
#define EXDRIVE 15  /* invalid drive */
#define EXCDIR  16  /* attempt to remove current dir */
#define EXNSD   17  /* not same device */
#define EXNMFLS 18  /* no more files */
#define EXWPD   19  /* write-protected diskette */
#define EXDEVQ  20  /* unknown device */
#define EXDNR   21  /* drive not ready */
#define EXCOMQ  22  /* unknown command */
#define EXCRC   23  /* CRC error */
#define EXBRSL  24  /* bad request structure length */
#define EXSEEK  25  /* seek error */
#define EXMEDIA 26  /* unknown media type */
#define EXSECNF 27  /* sector not found */
#define EXPAPER 28  /* printer out of paper */
#define EXWRITE 29  /* write fault */
#define EXREAD  30  /* read fault */
#define EXFAIL  31  /* general failure */
#define EXSHARE 32  /* sharing violation */
#define EXLOCK  33  /* lock violation */
#define EXCHGD  34  /* changed disk */
#define EXFCB   35  /* FCB unavailable */
#define EXSHBUF 36  /* sharing buffer overflow */
#define EXNETRQ 50  /* network request not supported */
#define EXDEVNL 51  /* remote device not listening */
#define EXDUPNM 52  /* duplicate name on network */
#define EXNAMNF 53  /* network name not found */
#define EXNBSY  54  /* network busy */
#define EXNETDV 55  /* network device does not exist */
#define EXNBIOS 56  /* net BIOS command limit exceeded */
#define EXNHWR  57  /* network hardware error */
#define EXNRESP 58  /* incorrect response from network */
#define EXNETQ  59  /* unexpected network error */
#define EXBADNA 60  /* incompatible remote adapter */
#define EXQUEUE 61  /* print queue full */
#define EXPFSIZ 62  /* not enough space for print file */
#define EXPFDEL 63  /* print file was deleted */
#define EXNNDEL 64  /* network name was deleted */
#define EXACDEN 65  /* access denied */
#define EXNETTP 66  /* network device type incorrect */
#define EXNNOTF 67  /* network name not found */
#define EXNAMLM 68  /* network name limit exceeded */
#define EXSESLM 69  /* session limit exceeded */
#define EXPAUSE 70  /* temporarily paused */
#define EXREQNA 71  /* network request not accepted */
#define EXREDP  72  /* print or disk redirection paused */
#define EXFXSTS 80  /* file exists */
#define EXNOENT 82  /* cannot make directory entry */
#define EXINT24 83  /* INT 24 failure */
#define EXREDIR 84  /* too many redirections */
#define EXDPDIR 85  /* duplicate redirection */
#define EXPSWRD 86  /* password not vaild */
#define EXPARM  87  /* invalid parameter */
#define EXNDFLT 88  /* network device fault */

#endif /* _EXTERR_H */

#ifndef _FCNTL_H

/* File mode constants */

#define O_RDONLY    0x00000000  /* file open for read only */
#define O_WRONLY    0x00000001  /* file open for write only */
#define O_RDWR      0x00000002  /* file open for read & write */
#define O_APPEND    0x00000008  /* seek to end of file before writing */
#define O_BINARY    0x00008000  /* do not translate LF <-> CR LF */
#define O_TEXT      0x00004000  /* translate LF <-> CR LF */
#define O_CREAT     0x00000100  /* if file doesn't exist, create new one */
#define O_TRUNC     0x00000200  /* if file already exists, truncate it */
#define O_EXCL      0x00000400  /* if file doesn't exist already, don't open */
#define O_NOINHERIT 0x00000080  /* child process doesn't inherit file */
#define O_RAW       O_BINARY



#define O_NONBLOCK  0x00000004	/* non-blocking I/O, POSIX style */
#define O_NOCTTY    0x00001000  /* POSIX REQUIRED */
#define O_DEFER     0x00000040	/* defered update		*/
#define O_NDELAY    0x00010000	/* Non-blocking I/O		*/

#endif /* _FCNTL_H */

#ifndef _PROCESS_H

/* mode values for spawn- routines */
#define P_WAIT          0
#define P_NOWAIT        1
#define P_OVERLAY       0

#define WAIT_CHILD 0
#define WAIT_GRANDCHILD 1

#endif /* _PROCESS_H */

#ifndef _SHARE_H

#define SH_COMPAT   0x0000  /* compatibility mode */
#define SH_DENYRW   0x0010  /* deny read/write mode */
#define SH_DENYWR   0x0020  /* deny write mode */
#define SH_DENYRD   0x0030  /* deny read mode */
#define SH_DENYNO   0x0040  /* deny none mode */

#endif /* _SHARE_H */

#ifndef _STAT_H

#ifndef S_IREAD
#define S_IREAD     0x100   /* read permission, owner */
#endif
#ifndef S_IWRITE
#define S_IWRITE    0x080   /* write permission, owner */
#endif

#endif /* _STAT_H */

#define mb_max              sizeof(wchar_t)

#ifndef _LOCKING_H

#define LK_UNLCK        0
#define LK_LOCK         1
#define LK_NBLCK        2
#define LK_RLCK         3
#define LK_NBRLCK       4

#endif /* _LOCKING_H */

#ifndef _MALLOC_H
/* _heap function constants */
#define _HEAPEMPTY      -1
#define _HEAPOK         -2
#define _HEAPBADBEGIN   -3
#define _HEAPBADNODE    -4
#define _HEAPEND        -5
#define _HEAPBADPTR     -6
#define _FREEENTRY      0
#define _USEDENTRY      1

#define _fcalloc( a, b ) calloc( (a), (b) )
#define _ncalloc( a, b ) calloc( (a), (b) )

#define _fmalloc(a) malloc(a)
#define _nmalloc(a) malloc(a)
#define   halloc(a) malloc(a)


#define _frealloc( a, b ) realloc( (a), (b) )
#define _nrealloc( a, b ) realloc( (a), (b) )

#define _ffree(a) free(a)
#define _nfree(a) free(a)
#define  hfree(a) free(a)

#define _fmsize(a) _msize(a)
#define _nmsize(a) _msize(a)

#define _fheapchk() _heapchk()
#define _nheapchk() _heapchk()

#define _fheapset() _heapset()
#define _nheapset() _heapset()

#define _fheapwalk() _heapwalk()
#define _nheapwalk() _heapwalk()

#define _fheapmin() _heapmin()
#define _nheapmin() _heapmin()

#endif /* _MALLOC_H */

#ifndef _MEMORY_H

#define _fmemcpy( a, b, c )     memcpy( (a), (b), (c) )
#define _fmemchr( a, b, c )     memchr( (a), (b), (c) )
#define _fmemcmp( a, b, c )     memcmp( (a), (b), (c) )
#define _fmemset( a, b, c )     memset( (a), (b), (c) )
#define _fmemccpy( a, b, c, d ) memccpy( (a), (b), (c), (d) )
#define _fmemicmp( a, b, c )    memicmp( (a), (b), (c) )

#endif /* _MEMORY_H */

/*-----------------------------------------------------*\
 | The following symbolic constants correspond to the  |
 | exception-handling bits in the Control Word of both |
 | the 80x87 and the Weitek coprocessors. Because the  |
 | error bits in the Status Word are in the same       |
 | positions, the same values can be used for the      |
 | Status Word as well.                                |
\*-----------------------------------------------------*/

#define IM      1               /* All NDPs. */
#define DM      2               /* 80x87 only */
#define ZM      4               /* All NDPs. */
#define OM      8               /* All NDPs. */
#define UM      16              /* All NDPs. */
#define PM      32              /* All NDPs. */
#define UOM     64              /* Weitek only. */
#define DCM     128             /* Weitek only. */

/* Coprocessor macros */
#define _status87() stndpsw_()
#define _fpreset()  init_ndp_()

/* Structure declaration for 80387 NDP environmental information. */
struct excep {
    unsigned short  cw;
    unsigned short  l_cw;           /* Padding. */
    unsigned short  sw;
    unsigned short  l_sw;           /* Padding. */
    unsigned short  tag;
    unsigned short  l_tag;          /* Padding. */
    unsigned        ip_off;
    unsigned short  cs_sel;
    unsigned short  l_cs_sel;       /* Padding. */
    unsigned        data_off;
    unsigned short  oper_sel;
    unsigned short  l_oper_sel;     /* Padding. */

    unsigned char   st0[10];
    unsigned char   st1[10];
    unsigned char   st2[10];
    unsigned char   st3[10];
    unsigned char   st4[10];
    unsigned char   st5[10];
    unsigned char   st6[10];
    unsigned char   st7[10];
    };

/* Structure declaration for 80287 NDP environmental information. */
struct excep287 {
    unsigned short  cw;
    unsigned short  sw;
    unsigned short  tag;
    unsigned short  l_cw;           /* Padding. */
    unsigned short  l_sw;           /* Padding. */
    unsigned short  l_tag;          /* Padding. */
    unsigned        ip_off;
    unsigned short  cs_sel;
    unsigned short  l_cs_sel;       /* Padding. */
    unsigned        data_off;
    unsigned short  oper_sel;
    unsigned short  l_oper_sel;     /* Padding. */

    unsigned char   st0[10];
    unsigned char   st1[10];
    unsigned char   st2[10];
    unsigned char   st3[10];
    unsigned char   st4[10];
    unsigned char   st5[10];
    unsigned char   st6[10];
    unsigned char   st7[10];
    };

/* Structure declaration for Weitek NDP environmental information. */
struct wexcep {
    unsigned short  cw;
    unsigned short  sw;
    union {
        unsigned    regs[32];
        float       f_regs[32];
        double      d_regs[16];
        } u;
    };

struct dostime_t {
    unsigned char hour;
    unsigned char minute;
    unsigned char second;
    unsigned char hsecond;
    };

struct dosdate_t {
    unsigned char  day;
    unsigned char  month;
    unsigned short year;
    unsigned char  dayofweek;
    };

extern  int _pmode;

struct interrupt_handlers {
    unsigned rm_seg,rm_off,pm_seg,pm_off;
    };

/*---------------------------------------------------------------------*\
 |                                                                     |
 |               MS-DOS data structures for NDP C                      |
 |                                                                     |
 |  Note that data structures obtained directly from MS-DOS may be     |
 |  packed; structures are unpacked by default in NDP-C.  To pack      |
 |  structures, use the -noholes compiler switch with care.            |
 |                                                                     |
 |  This tactic will work only in small files that do not use the      |
 |  stdio macros or similar structure-dependent forms unless the       |
 |  rest of the files in the application use packed structures as      |
 |  well -- hence it may be difficult to use -noholes correctly except |
 |  in small modules.                                                  |
 |                                                                     |
 |  Two methods of getting around these difficulties can be suggested: |
 |      a) copy packed structures to unpacked structures on exit from  |
 |         the low-level routines                                      |
 |      b) access structures as though they were just binary character |
 |         arrays; it might be easiest to write simple functions that  |
 |         extract the relevant data from the structures.              |
 |                                                                     |
 |---------------------------------------------------------------------|
 |                                                                     |
 |  Another method of dealing with packed structures is to use the     |
 |  #pragma X89 and #pragma Z89 directives. Precede the structure      |
 |  declaration with #pragma X89, and follow it with #pragma Z89, as   |
 |  in the following example:                                          |
 |                                                                     |
 |  #pragma X89                                                        |
 |  struct q {                                                         |
 |      char c;                                                        |
 |      long l;                                                        |
 |      };                                                             |
 |  #pragma Z89                                                        |
 |                                                                     |
 |  The following two structures are packed if this header file is     |
 |  included.                                                          |
\*---------------------------------------------------------------------*/

/* only under DOS is it sent to the operating system, which requires that
   it be packed, so only pack under DOS
*/
#ifdef __MSDOS__
#pragma X89
#endif
struct find_t {             /* Comes back from DOS as packed structure! */
#if defined(__OS2__)
    unsigned long curhnd;
#elif defined(__WIN32__)
    void *curhnd;
#else
    char reserved[21];
#endif
    char attrib;
    unsigned short wr_time;
    unsigned short wr_date;
    long size;
#ifdef __MSDOS__
    char name[13];
#else /* __WIN32__ or __OS2__ */
    char name[_MAX_FNAME];
#endif
    };
#ifdef __MSDOS__
#pragma Z89
#endif

#ifndef _MALLOC_H

struct _heapinfo {
    int * _pentry;
    int _size;
    int _useflag;
    };

#endif /* _MALLOC_H */

#ifndef _TIMEB_H

struct timeb {
    time_t time;
    unsigned short millitm;
    short timezone;
    short dstflag;
    };

#endif /* _TIME_H */

#ifndef _UTIME_H

struct utimbuf {
    time_t actime;
    time_t modtime;
    };

#endif /* _UTIME_H */


/* items for MSDOS only */

#ifdef __MSDOS__

#ifndef _BIOS_H
/* _bios_ constants */
#define _COM_CHR7         2
#define _COM_CHR8         3
#define _COM_STOP1        0
#define _COM_STOP2        4
#define _COM_NOPARITY     0
#define _COM_EVENPARITY  24
#define _COM_ODDPARITY    8
#define _COM_110          0
#define _COM_150         32
#define _COM_300         64
#define _COM_600         96
#define _COM_1200       128
#define _COM_2400       160
#define _COM_4800       192
#define _COM_9600       224
#define _COM_INIT         0
#define _COM_SEND         1
#define _COM_RECEIVE      2
#define _COM_STATUS       3
#define _DISK_RESET     0   /* reset disk controller */
#define _DISK_STATUS    1   /* get disk status */
#define _DISK_READ      2   /* read disk sectors */
#define _DISK_WRITE     3   /* write disk sectors */
#define _DISK_VERIFY    4   /* verify disk sectors */
#define _DISK_FORMAT    5   /* format disk track */
#define _PRINTER_WRITE    0
#define _PRINTER_INIT     1
#define _PRINTER_STATUS   2
#define _KEYBRD_READ        0
#define _KEYBRD_READY       1
#define _KEYBRD_SHIFTSTATUS 2
#define _NKEYBRD_READ           0x10
#define _NKEYBRD_READY          0x11
#define _NKEYBRD_SHIFTSTATUS    0x12
#define _TIME_GETCLOCK 0
#define _TIME_SETCLOCK 1

struct diskinfo_t {
    unsigned drive;
    unsigned head;
    unsigned track;
    unsigned sector;
    unsigned nsectors;
    unsigned bytes_per_sector;
    char     *buffer;
    };

/* 32-bit register structure is used by rm_int386, int386, int386x */

struct DOUBLEREGS {     /* Double-word registers. */
    unsigned long   eax;
    unsigned long   ebx;
    unsigned long   ecx;
    unsigned long   edx;
    unsigned long   esi;
    unsigned long   edi;
    unsigned long   eflag;
    };

struct WORDREGS {       /* Word registers. */
    unsigned short  ax, l_ax;
    unsigned short  bx, l_bx;
    unsigned short  cx, l_cx;
    unsigned short  dx, l_dx;
    unsigned short  si, l_si;
    unsigned short  di, l_di;
    unsigned short  cflag, l_cflag;
    };

struct BYTEREGS {       /* Byte registers. */
    unsigned char   al, ah, l_al, l_ah;
    unsigned char   bl, bh, l_bl, l_bh;
    unsigned char   cl, ch, l_cl, l_ch;
    unsigned char   dl, dh, l_dl, l_dh;
    unsigned long   esi;
    unsigned long   edi;
    unsigned char   flag, lr_flag, rl_flag, ll_flag;
    };

union REGS {
    struct DOUBLEREGS   d;
    struct WORDREGS     w;
    struct BYTEREGS     b;
    };

/* 16-bit register structure is used by int86, intdos, int86x, intdosx */

struct WORDREGS16 {       /* Word registers. */
    unsigned short  ax;
    unsigned short  bx;
    unsigned short  cx;
    unsigned short  dx;
    unsigned short  si;
    unsigned short  di;
    unsigned short  cflag;
    };

struct BYTEREGS16 {       /* Byte registers. */
    unsigned char   al, ah;
    unsigned char   bl, bh;
    unsigned char   cl, ch;
    unsigned char   dl, dh;
    unsigned short  si;
    unsigned short  di;
    unsigned short  cflag;
    };

union REGS16 {
    struct WORDREGS16   x;
    struct BYTEREGS16   h;
    };

/* Segment register structure is used by
   rm_int386, int386x, int86x, intdosx,
   and segread  */

struct SREGS {          /* Segment registers. */
    unsigned short es,cs,ss,ds;
    };

#endif /* _BIOS_H */

#pragma X89
struct diskfree_t {
    unsigned total_clusters;
    unsigned avail_clusters;
    unsigned sectors_per_cluster;
    unsigned bytes_per_sector;
    };
#pragma Z89

struct DOSERROR {
    int exterror;

#ifdef __NDPX__
    char _class;
#else
    char class;
#endif

    char action;
    char locus;
    };

#endif /* MSDOS */

#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__                 /* C++ */
   extern "C" {
#endif

void      (assert)(int);
int       bcmp(char *_B1, char *_B2, int _N);
void      bcopy(char *_Src, char *_Dest, unsigned int _N);
void      bufcpy(char *_Dest, char *_Src, int _N);
void      bzero(char *, int);
double    cabs(double _Real, double _Imag);
void      cfree(char *);
void      _cleanup(void);
unsigned  _clear87(void);
void      clearn(int n, char *);
void      clrndpex_(void);
unsigned  _control87(unsigned _Ctrl, unsigned _Mask);
void	  cs_ip(unsigned *_Cs, unsigned *_Ip);
void      date(char *);
void      dosdat(int *_Month, int *_Day, int *_Year, int *_Day_of_week);
void      dostim(int *_Hour, int *_Min, int *_Sec, int *_Hsec);
unsigned  dsab_ex_(unsigned *);
int       dup(int _Handle);
int       dup2(int _Handle1, int _Handle2);
int       eof(int _Handle);
unsigned  enab_ex_(unsigned *);
char *    ecvt(double _Value, int _Ndig, int *_Decpt, int *_Sign);
int       eprintf(const char *_Format, ...);
double    erf(double);
double    erfc(double);
void      _exit(int _Status);
int       fcloseall(void);
char *    fcvt(double _Value, int _Ndig, int *_Decpt, int *_Sign);
void      fflush_buf_(void);
int       ffs(int);
long      filelength(int _Handle);
void      filln(int, char *, char);
int       fls(int);
int       flushall(void);
FILE *    fdopen(int _Fno, const char *_Mode);

#ifndef INDPNDNT_FLIB 

FILE *    _fsopen(const char *_Path, const char *_Mode, int _Shflag);
FILE *    _fsreopen(const char *_Path, const char *_Mode, FILE *_Fp, 
		int _Shflag);

#endif

void      ftime(struct timeb *);
double    gamma(double);
char *    gcvt(double _Value, int _Ndig, char *_Buf);
long int  getl(FILE *);
int       getpid(void);
int       getw(FILE *);
double    hypot(double,double);
void      idate(int *_Pmo, int *_Pday, int *_Pyear);
char *    index(char *, char);
void      init_ndp_(void);
int       isinf(double);
int       isnan(double);
char *    itoa(int _Value, char *_String, int _Radix);
void      _itob(unsigned int, char *);
void      _itoh(unsigned int, char *);
void      _itoo(unsigned int, char *);
unsigned  ldndpcw_(unsigned *);
void      ldndpenv_(struct excep *);
double    j0(double);
double    j1(double);
double    jn(int,double);
char *    ltoa(long _Value, char *_String, int _Radix);
void      _makepath(char *_Path, char *_Drive, char *_Dir, char *_Fname, char *_Ext);
void *    memccpy(void *_Dest, void *_Src, int _C, unsigned _Count);
int       memicmp(void *_S1, void *_S2, unsigned int _N);
char *    mktemp(char *);
size_t    _msize(void *);
unsigned  ndptype_(void);
unsigned  precis_(int *);
long int  putl(long int, FILE *);
int       putw(int, FILE *);
float     racos(float);
float     rasin(float);
float     ratan(float);
float     ratan2(float, float);
float     rcos(float);
float     rcosh(float);
int       read(int _Fno, void *_Buf, unsigned _Size);
int       ret_ex_hdl_(void);
float     rexp(float);
float     rfrexp(float, int *);
char *    rindex(const char *, int);
float     rldexp(float, int);
float     rlog(float);
float     rlog10(float);
unsigned  round_(int *);
float     rpow(float, float);
float     rsin(float);
float     rsinh(float);
float     rsqrt(float);
float     rtan(float);
float     rtanh(float);
char *    sbrk(int _Size);
void      _searchenv(char *_Name, char *_Env, char *_Path);
int       sec_100(void);
int       secnds(int _Lasttime);
int       set_ex_hdl_(void (*_Fcn)());
void      setlinebuf(FILE *);
int       sopen(const char *_Path, int _Oflag, int _Shflag, ...);
void      _splitpath(char *_Path, char *_Drive, char *_Dir, char *_Fname, char *_Ext);
unsigned  stndpcw_(void);
unsigned  stndpenv_(struct excep *);
unsigned  stndpsw_(void);
int       strcmpi(char *, char *);
char *    _strdate(char *);
char *    strdup(char *);
char *    _strerror(char *);
int       stricmp(char *, char *);
int       strindex(char *_Str, char *_Sub);
char *    strlwr(char *);
int       strnicmp(char *, char *, int);
char *    strnset(char *_String, int _C, int _Count);
char *    strrev(char *);
int       strrindex(char *_Str, char *_Sub);
char *    strsave(char *);
char *    strset(char *, int);
char *    _strtime(char *);
char *    strupr(char *);
void      swab(char *_Src, char *_Dest, int _I);
long      tell(int _Handle);
char *    tempnam(const char *_Dir, const char *_Prefix);
void      time_(char *_String);
void      timedate (int *_Year, int *_Month, int *_Day, int *_Hour, 
              int *_Minute, int *_Second, int *_Hsec);
int	  __timezone();
char *    ultoa(unsigned long _Value, char *_String, int _Radix);
double    y0(double);
double    y1(double);
double    yn(int, double);

#if defined(__MSDOS__) || defined(__OS2__) || defined(__WIN32__)

int       access(const char *_Pathname, int _Mode);
char *    cgets(char *_String);
int       chdir(const char *_Path);
int       chmod(const char *_Path, int _Pmode);
int       chsize(int _Handle, long _Size);
int       ck_real(double _Value);
int       ck_shrt(float _Value);
int       close(int _Fno);
int       cputs(const char *_String);
int       creat(const char *, int);
int       cvif_(float *);
int       cvid_(double *);
unsigned  _dos_findfirst(const char *_Path, unsigned _Atr, struct find_t *_Buf);
unsigned  _dos_findnext(struct find_t *_Buffer);
void      _dos_getdate(struct dosdate_t *);
void      _dos_gettime(struct dostime_t *);
int       execl(char *_Path, char *_Arg0,...);
int       execle(char *_Path, char *_Arg0,...);
int       execlp(char *_Name, char *_Arg0,...);
int       execlpe(char *_Name, char *_Arg0,...);
int       execv(char *_Path, char **_Args);
int       execve(char *_Path, char **_Args, char **_Envp);
int       execvp(char *_Name, char **_Args);
int       execvpe(char *_Name, char **_Args, char **_Envp);
unsigned  _freect(size_t _Size);
int       getch(void);
int       getche(void);
char *    getcwd(char *_Path, int _N);
char *    _getdcwd(int _Drive, char *_Path, int _N);
int       _heapchk(void);
int       _heaprun(void);
int       _heapset(unsigned _Fill);
int       _heapwalk(struct _heapinfo *);
unsigned  inf_ctl_(int *);
int       isatty(int _Fno);
char *    lfind(const char *_Key, const char *_Base, unsigned *_Num,
                unsigned _Width,
                int (*_Compare)(const void *_Elem1, const void *_Elem2));
int       locking(int _Handle, int _Mode, long _Nbyte);
long      lrotl(long _Value, int _Count);
long      lrotr(long _Value, int _Count);
char *    lsearch(const char *_Key, const char *_Base, unsigned *_Num,
                unsigned _Width,
                int (*_Compare)(const void *_Elem1, const void *_Elem2));
long      lseek(int _Fno, long _Offset, int End);
size_t    _memavl(void);
size_t    _memmax(void);
int       _memory_address(char *_Ptr, unsigned int *_Linear, unsigned int *_Physical);
int       mkdir(const char *_Path);
int       open(const char *, int, ...);
int       putch(int);
int       putenv(char *_String);
void      pxerror(char *);
int       rmdir(const char *_Path);
short     rotl(short _Value, int _Count);
short     rotr(short _Value, int _Count);
int       setmode(int _Handle, int _Mode);
int       spawnl(int _Modeflag, char *_Path, char *_Arg0,...);
int       spawnle(int _Modeflag, char *_Path, char *_Arg0,...);
int       spawnlp(int _Modeflag, char *_Name, char *_Arg0,...);
int       spawnlpe(int _Modeflag, char *_Name, char *_Arg0,...);
int       spawnv(int _Modeflag, char *_Path, char **_Args);
int       spawnve(int _Modeflag, char *_Path, char **_Args, char **_Envp);
int       spawnvp(int _Modeflag, char *_Name, char **_Args);
int       spawnvpe(int _Modeflag, char *_Name, char **_Args, char **_Envp);
double	  temp_dbl(unsigned char *_Tempaddr);
int       truncate(char *_Path, unsigned long int _Length);
void      tzset(void);
int       ungetch(int);
int       unlink(char *_Path);
int       utime(char *_Path, struct utimbuf *_Timeptr);
int       write(int _Fno, const void *_Buf, unsigned int _Size);

#endif /* __MSDOS__ || __OS2__ || __WIN32__ */

#ifdef __MSDOS__
int       bdos(int _Dosfn, int _Dosdx, int _Dosal);
void      beep(void);
unsigned  _bios_disk(unsigned _Service, struct diskinfo_t *_Info);
unsigned  _bios_equiplist(void);
unsigned  _bios_keybrd(unsigned _Service);
unsigned  _bios_memsize(void);
unsigned  _bios_printer(unsigned _Service, unsigned _Printer, unsigned _Data);
unsigned  _bios_serialcom(unsigned _Service, unsigned _Port, unsigned _Data);
unsigned  _bios_timeofday(unsigned _Service, long *_Clockcount);
void      blk_bm(void *_Buf, int _Selector, unsigned _Offset, unsigned _Count);
void      blk_mb(void *_Buf, int _Selector, unsigned _Offset, unsigned _Count);
unsigned  _dos_allocmem(unsigned _Size, unsigned *_Segment);
unsigned  _dos_close(unsigned _Handle);
unsigned  _dos_creat(char *_Path, unsigned _Attribute, unsigned *_Handle);
unsigned  _dos_creatnew(char *_Path, unsigned _Attribute, unsigned *_Handle);
unsigned  _dos_freemem(unsigned _Segment);
unsigned  _dos_getdiskfree(unsigned _Drive, struct diskfree_t *_Diskspace);
void      _dos_getdrive(unsigned *_Driveno);
unsigned  _dos_getfileattr(char *_Path, unsigned *_Attribute);
unsigned  _dos_getftime(unsigned _Handle, unsigned *_Date, unsigned *_Time);
void      _dos_keep(unsigned _Retcode, unsigned _Memsize);
unsigned  _dos_open(char *_Path, unsigned _Mode, unsigned *_Handle);
unsigned  _dos_setblock(unsigned _Size, unsigned _Segment, unsigned *_Maxsize);
unsigned  _dos_setdate(struct dosdate_t *);
void      _dos_setdrive(unsigned _Drive, unsigned *_P_ndrives);
unsigned  _dos_setfileattr(char *_Path, unsigned _Attribute);
unsigned  _dos_setftime(unsigned _Handle, unsigned _Date, unsigned _Time);
unsigned  _dos_settime(struct dostime_t *);
void	  dosexterr(struct DOSERROR *);
void *    get_DOS_dta(void);
void      hostfree(int _Buffer);
int       hostmalloc(int _Size);
int       _ignore_breaks(void);
int       inkey$(void);
int       inp(unsigned _Port);
int       inpd(unsigned _Port);
int       inpw(unsigned _Port);
void      install_pm_isr(int _Interrupt, void (*_New_handler)());
void      int386(int _Interrupt, union REGS *_Inregs, union REGS *_Outregs);
void      int386x(int _Interrupt, union REGS *_Inregs, union REGS *_Outregs,
              struct SREGS *_Sregs);
int       int86(int _Interrupt, union REGS16 *_Inregs, union REGS16 *_Outregs);
int       int86x(int _Interrupt, union REGS16 *_Inregs, union REGS16 *_Outregs,
              struct SREGS *_Sregs);
int       intdos(union REGS16 *_Inregs, union REGS16 *_Outregs);
int       intdosx(union REGS16 *_Inregs, union REGS16 *_Outregs,
              struct SREGS *_Sregs);
int       kbhit(void);
_pvoid    mapdev(unsigned _Address, unsigned _Count);
void      memcpy_from_host(char *_Buffer, int _Handle, int _Count);
void      memcpy_to_host(int _Handle, char *_Buffer, int _Count);
void      note(int _Frequency, int _Duration);
_int      outp(unsigned _Port, int _Byte);
_int      outpd(unsigned _Port, unsigned _Doubleword);
_int      outpw(unsigned _Port, unsigned _Word);
int       pauseb(void);
int       peek(int _Address);
char      peekb(int _Address);
short     peekw(int _Address);
void      poke(int _Address, int _Value);
void      pokeb(int _Address, char _Value);
void      pokew(int _Address, short _Value);
int       _read_typeahead(int *_Keys);
void      restore_isr(int _Interrupt, struct interrupt_handlers *_Handler);
_pchar    rm_alloc(int _Size, int *_Rm_seg);
void      rm_free(unsigned _Rm_seg);
int       rm_int386(int _Interrupt, union REGS *_Regs, struct SREGS *_Sregs);
unsigned  rm_resize(unsigned _Size, unsigned _Rm_seg, unsigned *_Maxsize);
void      save_isr(int _Interrupt, struct interrupt_handlers *_Handler);
void      segread(struct SREGS *);
int       shiftstate(void);
void      show_registers(void);
int       _user_break(void);
int       _watch_breaks(void);

#ifdef __i860
unsigned  _dos_read(unsigned _Handle, unsigned _Buffer, unsigned _Count, 
              unsigned *_Bytes);
unsigned  _dos_write(unsigned _Handle, unsigned _Buffer, unsigned _Count, 
              unsigned *_Bytes);
int       _pause(void);
#else
unsigned  _dos_read(unsigned _Handle, char *_Buffer, unsigned _Count, 
              unsigned * _Bytes);
unsigned  _dos_write(unsigned _Handle, char *_Buffer, unsigned _Count, 
              unsigned * _Bytes);
int       pause(void);
#endif

#endif /* __MSDOS__ */

#if defined(__OS2__) || defined(__WIN32__)

int	  _CRT_init(void);
void	  _CRT_term(unsigned long);
unsigned long	_DLL_InitTerm(unsigned long _Modhandle, unsigned long _Flag);
unsigned  _dos_findclose(struct find_t *_Buff);
int	  _NumFiles(int);

#endif

#ifdef __NDPX__         /* C++ */
   }
#endif

#else                   /* K&R */

void      (assert)();
int       bcmp();
void      bcopy();
void      bufcpy();
void      bzero();
double    cabs();
void      cfree();
void      _cleanup();
void      clearn();
void      dosdat();
void      dostim();
char *    ecvt();
int       eprintf();
double    erf();
double    erfc();
void      _exit();
int       fcloseall();
char *    fcvt();
FILE *    fdopen();
void      fflush_buf_();
int       ffs();
void      filln();
int       fls();

#ifndef INDPNDNT_FLIB 

FILE *    _fsopen();
FILE *    _fsreopen(); 

#endif

double    gamma();
char *    gcvt();
long int  getl();
int       getpid();
int       getw();
double    hypot();
char *    index();
int       isinf();
int       isnan();
double    j0();
double    j1();
double    jn();
void      _makepath();
void *    memccpy();
int       memicmp();
char *    mktemp();
size_t    _msize();
long int  putl();
int       putw();
float     racos();
float     rasin();
float     ratan();
float     ratan2();
float     rcos();
float     rcosh();
int       read();
float     rexp();
float     rfrexp();
char *    rindex();
float     rldexp();
float     rlog();
float     rlog10();
float     rpow();
float     rsin();
float     rsinh();
float     rsqrt();
float     rtan();
float     rtanh();
char *    sbrk();
void      setlinebuf();
int       setmode();
int       sopen();
void      _splitpath();
int       strindex();
int       strrindex();
char *    strsave();
void      swab();
int	  __timezone();
double    y0();
double    y1();
double    yn();

#if defined(__MSDOS__) || defined(__OS2__) || defined(__WIN32__)

int       access();
char *    cgets();
int       chdir();
int       chmod();
int       chsize();
int       ck_real();
int       ck_shrt();
unsigned  _clear87();
int       close();
void      clrndpex_();
unsigned  _control87();
int       cputs();
int       creat();
int	  cs_ip();
int       cvif_();
int       cvid_();
void      date();
unsigned  _dos_findfirst();
unsigned  _dos_findnext();
void      _dos_getdate();
void      _dos_gettime();
unsigned  dsab_ex_();
int       dup();
int       dup2();
int       eof();
unsigned  enab_ex_();
int	  execl();
int	  execle();
int	  execlp();
int	  execlpe();
int	  execv();
int	  execve();
int	  execvp();
int	  execvpe();
long      filelength();
int       flushall();
unsigned  _freect();
void      ftime();
int       getch();
int       getche();
char *    getcwd();
char *    _getdcwd();
int       _heapchk();
int       _heaprun();
int       _heapset();
int       _heapwalk();
void      idate();
unsigned  inf_ctl_();
void      init_ndp_();
int       isatty();
char *    itoa();
void      _itob();
void      _itoh();
void      _itoo();
unsigned  ldndpcw_();
void      ldndpenv_();
char *    lfind();
int       locking();
long      lrotl();
long      lrotr();
char *    lsearch();
long      lseek();
char *    ltoa();
size_t    _memavl();
size_t    _memmax();
int       _memory_address();
int       mkdir();
unsigned  ndptype_();
int       open();
unsigned  precis_();
int       putch();
int       putenv();
void      pxerror();
int       ret_ex_hdl_();
int       rmdir();
short     rotl();
short     rotr();
unsigned  round_();
void      _searchenv();
int       sec_100();
int       secnds();
int       set_ex_hdl_();
int	  setmode();
int       spawnl();
int       spawnle();
int       spawnlp();
int       spawnlpe();
int       spawnv();
int       spawnve();
int       spawnvp();
int       spawnvpe();
unsigned  stndpcw_();
unsigned  stndpenv_();
unsigned  stndpsw_();
int       strcmpi();
char *    _strdate();
char *    strdup();
char *    _strerror();
int       stricmp();
char *    strlwr();
int       strnicmp();
char *    strnset();
char *    strrev();
char *    strset();
char *    _strtime();
char *    strupr();
long      tell();
double	  temp_dbl();
char *    tempnam();
void      time_();
void      timedate();
int       truncate();
void      tzset();
char *    ultoa();
int       ungetch();
int       unlink();
int       utime();
int       write ();

#endif /* (__MSDOS__) || (__OS2__) || (__WIN32__) */

#ifdef __MSDOS__
int       bdos();
void      beep();
unsigned  _bios_disk();
unsigned  _bios_equiplist();
unsigned  _bios_keybrd();
unsigned  _bios_memsize();
unsigned  _bios_printer();
unsigned  _bios_serialcom();
unsigned  _bios_timeofday();
void      blk_bm();
void      blk_mb();
unsigned  _dos_allocmem();
unsigned  _dos_close();
unsigned  _dos_creat();
unsigned  _dos_creatnew();
unsigned  _dos_freemem();
unsigned  _dos_getdiskfree();
void      _dos_getdrive();
unsigned  _dos_getfileattr();
unsigned  _dos_getftime();
void      _dos_keep();
unsigned  _dos_open();
unsigned  _dos_read();
unsigned  _dos_setblock();
unsigned  _dos_setdate();
void      _dos_setdrive();
unsigned  _dos_setfileattr();
unsigned  _dos_setftime();
unsigned  _dos_settime();
unsigned  _dos_write();
void      dosexterr();
char *    get_DOS_dta();
void      hostfree();
int       hostmalloc();
int       _ignore_breaks();
int       inkey$();
int       inp();
int       inpd();
int       inpw();
void      install_pm_isr();
void      int386();
void      int386x();
int       int86();
int       int86x();
int       intdos();
int       intdosx();
int       kbhit();
_pvoid    mapdev();
void      memcpy_from_host();
void      memcpy_to_host();
void      note();
_int      outp();
_int      outpd();
_int      outpw();
int       pauseb();
int       peek();
char      peekb();
short     peekw();
void      poke();
void      pokeb();
void      pokew();
int       _read_typeahead();
void      restore_isr();
_pchar    rm_alloc();
void      rm_free();
int       rm_int386();
unsigned  rm_resize();
void      save_isr();
void      segread();
int       shiftstate();
void      show_registers();
int       _user_break();
int       _watch_breaks();

#ifdef __i860
int       _pause ();
#else
int       pause ();
#endif

#endif /* __MSDOS__ */

#if defined(__OS2__) || defined(__WIN32__)

int	  _CRT_init();
void	  _CRT_term();
unsigned long _DLL_InitTerm();
unsigned  _dos_findclose();
int	  _NumFiles();

#endif

#endif /* __STDC__ || __NDPX __ */
#endif /* _OS_H */
