/*  
**  fstream.h		C++ Runtime
**
**  Copyright (C)	Microway, Inc. 1987 - 1994.
**			P.O. BOX 79
**			Kingston, MA. 02364
**			(508) 746 - 7341 Voice
**			(508) 746 - 4678 FAX
**			e-mail tech@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/
#ifndef __FSTREAM_H
# define __FSTREAM_H
# include <iostream.h>
# ifdef __cppv21
#  define __ios ios::
# else
#  define __ios
# endif

#pragma ghs novirtual=(ifstream,ofstream,fstream)

class filebuf : public streambuf {
public:
    static const int openprot;

		filebuf();
		filebuf(int);
		filebuf(int, char *, int);

    filebuf *	attach(int);
    filebuf *	close();
    filebuf *	open(const char *, int, int =openprot);
    int 	fd()		    { return _fd; }
    int 	is_open()	    { return _open; }
    streampos	seekoff(streamoff, __ios seek_dir, int);
    streambuf * setbuf(char *, int);
    int 	sync();

   virtual	~filebuf();
   virtual int	underflow();
   virtual int	overflow(int =EOF);


protected:
    char	_open;
    int 	_fd;
    int 	_mode;			// This is often wrong, so why have it?
};

class ifstream : public istream {
public:
		ifstream()	    { init(&buf); }
		ifstream(const char *nm,int m=ios::in, int p=filebuf::openprot)
				    { init(&buf); open(nm,m,p); }
		ifstream(int fd)    : buf(fd)
				    { init(&buf);
				      if ( buf.fd()==-1)
					    _state = badbit;
				    }
		ifstream(int fd,char *p,int l): buf(fd,p,l)
				    { init(&buf);
				      if ( buf.fd()==-1)
					    _state = badbit;
				    }
    void	attach(int fd)	    { if ( buf.attach(fd)==NULL) _state |= badbit; }
    void	open(const char *nm, int m=ios::in, int p=filebuf::openprot)
				    { if ( buf.open(nm,m,p)==NULL )
					    _state = badbit;
				    }
    void	close() 	    { if ( buf.close()==NULL ) _state |= badbit; else _state=0; }
    filebuf *	rdbuf() 	    { return( &buf ); }
    void	setbuf(char *p,int l){ if ( buf.setbuf(p,l)==NULL ) _state |= badbit; }
private:
    filebuf	buf;
};

class ofstream : public ostream {
public:
		ofstream()	    { init(&buf); }
		ofstream(const char *nm,int m=ios::out, int p=filebuf::openprot)
				    { init(&buf); open(nm,m,p); }
		ofstream(int fd)    : buf(fd)
				    { init(&buf);
				      if ( buf.fd()==-1)
					    _state = badbit;
				    }
		ofstream(int fd,char *p,int l): buf(fd,p,l)
				    { init(&buf);
				      if ( buf.fd()==-1)
					    _state = badbit;
				    }
    void	attach(int fd)	    { if ( buf.attach(fd)==NULL) _state |= badbit; }
    void	open(const char *nm, int m=ios::in, int p=filebuf::openprot)
				    { if ( buf.open(nm,m,p)==NULL )
					    _state = badbit;
				    }
    void	close() 	    { if ( buf.close()==NULL ) _state |= badbit; else _state=0; }
    filebuf *	rdbuf() 	    { return( &buf ); }
    void	setbuf(char *p,int l){ if ( buf.setbuf(p,l)==NULL ) _state |= badbit; }
private:
    filebuf	buf;
};

class fstream : public iostream {
public:
		fstream()	   { init(&buf); }
		fstream(char *nm,int m=ios::out, int p=filebuf::openprot)
				    { init(&buf); open(nm,m,p); }
		fstream(int fd)    : buf(fd)
				    { init(&buf);
				      if ( buf.fd()==-1)
					    _state = badbit;
				    }
		fstream(int fd,char *p,int l): buf(fd,p,l)
				    { init(&buf);
				      if ( buf.fd()==-1)
					    _state = badbit;
				    }
    void	attach(int fd)	    { if ( buf.attach(fd)==NULL) _state |= badbit; }
    void	open(char *nm, int m=ios::in, int p=filebuf::openprot)
				    { if ( buf.open(nm,m,p)==NULL )
					    _state = badbit;
				    }
    void	close() 	    { if ( buf.close()==NULL ) _state |= badbit; else _state=0; }
    filebuf *	rdbuf() 	    { return( &buf ); }
    void	setbuf(char *p,int l){ if ( buf.setbuf(p,l)==NULL ) _state |= badbit; }
private:
    filebuf	buf;
};

# undef __ios
#endif
