/* ********************************************************************
   * raw16tosun: Convert a 16 bits sampled audio (16KHz) file         *
   * to sun audio (Ulaw 8000 hz) file                                 *
   *                                                                  *
   * This program is strongly inspired by SOX and AUDIO2SUN source    *
   *                                                                  *
   *  This source code is freely redistributable and may be used for  *
   * any purpose.  This copyright notice must be maintained.          *
   * University of Geneva:      Gaudinat Arnaud: 13 octobre 1995      * 
   ******************************************************************** /


  
/************************************************************************/
/* sound2sun.c - Convert sampled audio files into uLAW format for the   */
/*               Sparcstation 1.                                        */
/*               Send comments to ..!rutgers!soleil!gopstein            */
/************************************************************************/
/*                                                                      */
/*  Modified November 27, 1989 to convert to 8000 samples/sec           */
/*   (contrary to man page)                                             */
/*  Modified December 13, 1992 to write standard Sun .au header with    */
/*   unspecified length.  Also made miscellaneous changes for           */
/*   VMS port.  (K. S. Kubo, ken@hmcvax.claremont.edu)                  */
/*  Fixed Bug with converting slow sample speeds                        */
/*                                                                      */
/************************************************************************/

/* for SOX
 * July 5, 1991
 * Copyright 1991 Lance Norskog And Sundry Contributors
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained.
 * Lance Norskog And Sundry Contributors are not responsible for
 * the consequences of using this software.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define DEFAULT_FREQUENCY 16000
#ifdef VMS
#define WR_OPEN           "w", "mbf=16"
#define READ_OPEN         "r", "mbf=16", "shr=get"
#else
#define WR_OPEN           "wb"
#define READ_OPEN         "rb"
#endif

FILE *infile, *outfile;

unsigned char st_linear_to_ulaw(int sample );
static void wr_header(FILE *optr, int taille);


main(int argc, char* argv[])
{
  int taille=0; 
  float frequency;
  unsigned char ch;
  int      ch0;
  int      ch1;

if ((argc != 3) && (argc != 5)) {
    fprintf(stderr,"Usage: sound2sun [-f frequency] infile outfile\n");
    exit(1);
  }

  if (argc == 5) {
    if (strcmp(argv[1], "-f") != 0) {
      fprintf(stderr, "Usage: sound2sun [-f frequency] infile outfile\n");
      exit(1);
    } else {
      frequency = atoi(argv[2]);
    }
  } else {
    frequency = DEFAULT_FREQUENCY;
  }

  if ((infile = fopen(argv[argc-2], READ_OPEN)) == NULL) {
    perror("Erreur d'ouverture infile");
    exit(0);
  }

  while (!feof(infile)) { 
    if (!feof(infile)) ch = fgetc(infile);
    taille++;
  }
  fclose(infile);

  if ((infile = fopen(argv[argc-2], READ_OPEN)) == NULL) {
    perror("Erreur d'ouverture infile");
    exit(0);
  }

  

  if ((outfile = fopen(argv[argc-1], WR_OPEN)) == NULL) {
    perror("Erreur d'ouverture outfile");
    exit(0);
  }
                             
  wr_header(outfile,taille);

  while (!feof(infile)) {
    ch1 = fgetc(infile);
    ch0 = fgetc(infile);

    ch0=ch0<<8;
    ch0=ch0|ch1;     
    ch=st_linear_to_ulaw(ch0);

    fputc((char) ch, outfile);
    ch1 = fgetc(infile);
    ch0 = fgetc(infile);

  }

  fclose(infile);
  fclose(outfile);
  
}



/* write a "standard" sun header with an unspecified length */
#define wrulong(fp, ul) putc((ul >> 24) & 0xff, fp); \
    putc((ul >> 16) & 0xff, fp); putc((ul >> 8) & 0xff, fp); \
    putc(ul & 0xff, fp);


static void wr_header(FILE* optr,int taille)
{
    wrulong(optr, 0x2e736e64);  /* Sun magic */
    wrulong(optr, 24);          /* header size in bytes */
    wrulong(optr, taille/2);       /* unspecified data size */
    wrulong(optr, 1);           /* Sun uLaw format */
    wrulong(optr, 8000);        /* sample rate by definition :-) */
    wrulong(optr, 1);           /* single channel */
}


/*
** Input: Signed 16 bit linear sample
** Output: 8 bit ulaw sample
*/

#undef ZEROTRAP      /* turn off the trap as per the MIL-STD */
#define uBIAS 0x84   /* define the add-in bias for 16 bit samples */
#define uCLIP 32635
#define ACLIP 31744

unsigned char st_linear_to_ulaw( int sample )
    {
    static int exp_lut[256] = {0,0,1,1,2,2,2,2,3,3,3,3,3,3,3,3,
                               4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
                               5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
                               5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
                               6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
                               6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
                               6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
                               6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
                               7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
                               7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
                               7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
                               7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
                               7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
                               7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
                               7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
                               7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7};
    int sign, exponent, mantissa;
    unsigned char ulawbyte;

   /* Get the sample into sign-magnitude. */
    sign = (sample >> 8) & 0x80;                /* set aside the sign */
    if ( sign != 0 ) sample = -sample;          /* get magnitude */
    if ( sample > uCLIP ) sample = uCLIP;               /* clip the magnitude */

    /* Convert from 16 bit linear to ulaw. */
    sample = sample + uBIAS;
    exponent = exp_lut[( sample >> 7 ) & 0xFF];
    mantissa = ( sample >> ( exponent + 3 ) ) & 0x0F;
    ulawbyte = ~ ( sign | ( exponent << 4 ) | mantissa );
#ifdef ZEROTRAP
    if ( ulawbyte == 0 ) ulawbyte = 0x02;       /* optional CCITT trap */
#endif

    return ulawbyte;
    }

