/*
 * FPMs-TCTS SOFTWARE LIBRARY
 *
 * File:    playsnd.cc
 * Purpose: listen to a sound pipe by writing it into the audio device
 * Author:  Frangois Bataille
 * Email :  bataille@tcts.fpms.ac.be
 *
 * THIS PROGRAM CAN BE DISTRIBUTED. IT IS FREE OF ANY RIGHT.
 *
 * HISTORY :
 *
 * 10/07/95 : Creted and tested on SUN Sparc 5
 *
 * TO DO :
 *
 * Set sampling frequency as a UNIX command line parameter.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/audioio.h>
#include <fcntl.h>
#include <sys/filio.h>
#include <unistd.h>
#include <math.h>
#include <sys/stropts.h>
#include <errno.h>
#define AUDIO_DEV       "/dev/audio"

int Audio_fd=-1;

struct sound_buffer {
   unsigned char *data;
   int size;
   } buff;

FILE *command_file;

main(int argc, char *argv[])
{
   setvbuf(stdout,NULL,_IONBF,0);
   struct audio_info Audio_state;
   buff.data=NULL;buff.size=0;
   buff.data=(unsigned char *)malloc(500);
   if ((Audio_fd=open(AUDIO_DEV, O_WRONLY)) < 0)
      {
      fprintf(stderr,"can't open device");
      }
   AUDIO_INITINFO(&Audio_state);
   ioctl(Audio_fd,I_FLUSH,FLUSHRW);
   Audio_state.play.encoding=3;
   Audio_state.play.buffer_size=512;
   Audio_state.play.channels=0;
   Audio_state.play.sample_rate=16000;
   Audio_state.play.precision=16;
   Audio_state.play.gain=200;
   ioctl(Audio_fd,AUDIO_SETINFO,&Audio_state);
   ioctl(Audio_fd,AUDIO_GETINFO,&Audio_state);

   if (argv[1]="-")
	command_file=stdin;
   else if ((command_file=fopen(argv[1],"rb")) == NULL)
	{
	    fprintf(stderr,"Error with %s input file !\n",argv[1]);
	    return(1);
	}

   while (fread(buff.data+buff.size,1,2,command_file)!=0)
       {
       buff.size+=2;
       if (buff.size==512)
          {
          write(Audio_fd,buff.data,buff.size);
          buff.size=0;
          }
       }
   write(Audio_fd,buff.data,buff.size); /* flush buffer */
   close(Audio_fd);
   fclose(command_file);
   free(buff.data);
}
