$! GAUDINAT ARNAUD                    Universiti de genhve
$!                                    27-OCT-1995
$! 
$! "ALL IN ONE" BATCH COMMAND FILE FOR USING MBROLA WITH VMS.
$! 
$! This command procedure converts the input file (phoneme) into an audio file
$! and plays it through the decsound.  It takes the following parameters
$!
$!      Param.    Default               Description.
$!
$!      P1        no default input     Input file (.pho)
$!
$!      P2        40                   Sound level for the decsound
$!
$!      P3        psola.au             Output file (.au)
$!
$ if P1 .eqs. "" THEN GOTO EXITERROR
$ if P1 .eqs. "_" THEN GOTO EXITERROR
$ if P3 .eqs. "" THEN P3 = "psola.au"
$ if P2 .eqs. "" THEN P2 = "40"
$ write sys$output "MBROLA synthesis"
$ MBROLA MBROLA_DIR:FR1-PC. 'P1 ola.raw
$ write sys$output ""
$ write sys$output "Audio format conversion for the Decsound system"
$ RAW2SUN ola.raw 'P3
$ write sys$output ""
$ write sys$output "Play the sound file..."
$ MCR DECSOUND -PLAY 'P3 -VOLUME 'P2
$ if P3 .eqs. "ola.au" THEN delete OLA.AU;*
$ delete OLA.raw;*
$ exit
$ EXITERROR:
$ write sys$output "MBR_OLA requires an input file"
$ exit
