PFont ef;
float radius;

// Wird einmal beim Start aufgerufen
void setup() {

  size(400,400, JAVA2D); // Anwendungsgroesse 
  // und Rendermodus

  frameRate(3); // Bildwiederholfrequenz
  cursor(CROSS); // Kreuz als Mauscursor
  smooth(); // Antialiasing
  textAlign(CENTER); // Texte zentriert
  noStroke();// keine Linie um Flaechen

  radius=150;
  ef = loadFont("URWPalladioL-BoldItal-48.vlw");      
  textFont(ef,17); // Font waehlen

}

// Wird entsprechend Framerate aufgerufen
void draw() {
  
  background(200);

  pushMatrix(); // Translationsmatrix speichern,
                // wird durch popMatrix wieder aktuell

  translate(width/2.0, height/2.0); // Verschieben, damit Uhrzentrum
                // Koordinatenursprung ist

  // Kreise fuer weiche 3D Kante 
  int dr;
  for (dr=50;dr>=20;dr-=3) {
    fill(120+3*dr);
    ellipse(0,0,2*(radius+dr),2*(radius+dr));
  }
  fill(250);
  ellipse(0,0,2*(radius+dr),2*(radius+dr));

  // Schleife ueber die Winkel
  for ( int i = 0; i < 60; i++ ) {

    float alpha = i / 60.0*TWO_PI;   
    float posx = sin(alpha)*radius;
    float posy = -cos(alpha)*radius;

    if ( i == second()  ) {
      // Die aktuelle Sekunde      
      fill(255,20,20); // Rot
      text(i, posx,posy);
    } 
    else if (i%5==0) {
      // Jede 5. Sekunde
      fill(60); // Dunkelgrau
      text(i, posx,posy);
    }      

    if ( i == minute() ) { 
      pushMatrix(); // Transformation speichern
      rotate(alpha); // Alles wird mit alpha rotiert
      fill( 90); // Fuellfarbe setzen
      quad(0,-5, -10,-30, 0,-130, 10,-30); // Polygon 
      popMatrix(); // Transformation zuruecksetzen
    }

    int  h = hour(); // Gibt Stunden von 0-23,
    h = h >= 12 ? h %12 : h; // Stunden auf 0-11
    int me = h*5 + (int) (minute()/12.0);
    if ( i == me ) {
      pushMatrix();
      rotate(alpha);
      fill( 120); // Fuellfarbe setzen
      quad(0,-5, -10,-30, 0,-80, 10,-30);      
      popMatrix();
    }
  }

  // Kleiner Kreis ueber Zifferblaettern
  fill(90);
  ellipse(0,0,20,20);
  
  popMatrix(); // Koordinatensystem wieder nach links oben
  
  // Bei gedrueckter Maus Datum anzeigen
  if ( mousePressed) {
    fill(255,20,20); // Rot
    text("Datum " + day() + "." + month() + "." + year(),mouseX, mouseY-10);      
  }


}



