/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.lang.reflect.Method;
import org.apache.xbean.propertyeditor.AbstractConverter;
import org.apache.xbean.propertyeditor.PropertyEditorException;

public class EnumConverter
extends AbstractConverter {
    public EnumConverter(Class type) {
        super(type);
    }

    protected Object toObjectImpl(String text2) {
        Class type = this.getType();
        try {
            return Enum.valueOf(type, text2);
        }
        catch (Exception cause) {
            try {
                int index = Integer.parseInt(text2);
                Method method = type.getMethod("values", new Class[0]);
                Object[] values2 = (Object[])method.invoke(null, new Object[0]);
                return values2[index];
            }
            catch (NumberFormatException e) {
            }
            catch (Exception e) {
                cause = e;
            }
            throw new PropertyEditorException("Value \"" + text2 + "\" cannot be converted to enum type " + type.getName(), cause);
        }
    }
}

