/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.ForGraph;
import guru.nidi.graphviz.attribute.ForLink;
import guru.nidi.graphviz.attribute.ForNode;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.model.Compass;
import guru.nidi.graphviz.model.CreationContext;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.ImmutableGraph;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableAttributed;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.Node;
import guru.nidi.graphviz.model.Port;

public final class Factory {
    private Factory() {
    }

    public static Graph graph() {
        return Factory.graph("");
    }

    public static Graph graph(String name) {
        return new ImmutableGraph().named(name);
    }

    public static Node node(String name) {
        return Factory.node(Label.of(name));
    }

    public static Node node(Label name) {
        return CreationContext.createNode(name);
    }

    public static Port port(String record) {
        return new Port(record, null);
    }

    public static Port port(Compass compass) {
        return new Port(null, compass);
    }

    public static Port port(String record, Compass compass) {
        return new Port(record, compass);
    }

    public static MutableGraph mutGraph() {
        return CreationContext.createMutGraph();
    }

    public static MutableGraph mutGraph(String name) {
        return Factory.mutGraph().setName(name);
    }

    public static MutableNode mutNode(String name) {
        return Factory.mutNode(name, false);
    }

    public static MutableNode mutNode(String name, boolean raw) {
        return Factory.mutNode(raw ? Label.raw(name) : Label.of(name));
    }

    public static MutableNode mutNode(Label name) {
        return CreationContext.createMutNode(name);
    }

    public static Link to(Node node) {
        return Link.to(node);
    }

    public static Link to(LinkTarget node) {
        return Link.to(node);
    }

    public static Link between(Port port, LinkTarget to) {
        return Link.between(port, to);
    }

    public static MutableAttributed<?, ForNode> nodeAttrs() {
        return CreationContext.get().nodeAttrs();
    }

    public static MutableAttributed<?, ForLink> linkAttrs() {
        return CreationContext.get().linkAttrs();
    }

    public static MutableAttributed<?, ForGraph> graphAttrs() {
        return CreationContext.get().graphAttrs();
    }
}

