/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Map;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ivy.IvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.DefaultIvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.MetadataProvider;
import org.gradle.api.internal.artifacts.repositories.resolver.ComponentMetadataAdapter;
import org.gradle.internal.component.external.model.ExternalComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveState;
import org.gradle.internal.component.external.model.ivy.IvyModuleResolveMetadata;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;

class CachedMetadataProvider
implements MetadataProvider {
    private final BuildableModuleComponentMetaDataResolveResult<ModuleComponentGraphResolveState> cachedResult;
    private final ComponentMetadata cachedComponentMetadata;
    private final boolean usable;

    CachedMetadataProvider(BuildableModuleComponentMetaDataResolveResult<ModuleComponentGraphResolveState> result) {
        this.cachedResult = result;
        boolean bl = this.usable = this.cachedResult.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved;
        if (this.usable) {
            ExternalComponentResolveMetadata legacyMetadata = this.cachedResult.getMetaData().getLegacyMetadata();
            this.cachedComponentMetadata = new ComponentMetadataAdapter(legacyMetadata);
        } else {
            this.cachedComponentMetadata = null;
        }
    }

    @Override
    public ComponentMetadata getComponentMetadata() {
        return this.cachedComponentMetadata;
    }

    @Override
    public IvyModuleDescriptor getIvyModuleDescriptor() {
        ExternalComponentResolveMetadata legacyMetadata = this.cachedResult.getMetaData().getLegacyMetadata();
        if (legacyMetadata instanceof IvyModuleResolveMetadata) {
            IvyModuleResolveMetadata ivyMetadata = (IvyModuleResolveMetadata)legacyMetadata;
            return new DefaultIvyModuleDescriptor((Map<NamespaceId, String>)ivyMetadata.getExtraAttributes(), ivyMetadata.getBranch(), ivyMetadata.getStatus());
        }
        return null;
    }

    @Override
    public boolean isUsable() {
        return this.usable;
    }
}

