/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore.disk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.pageStore.IPersistedPage;
import org.apache.wicket.util.collections.IntHashMap;
import org.apache.wicket.util.lang.Bytes;

public class PageWindowManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<FileWindow> windows = new ArrayList<FileWindow>();
    private IntHashMap<Integer> idToWindowIndex = null;
    private IntHashMap<Integer> windowIndexToPageId = null;
    private int indexPointer = -1;
    private int totalSize = 0;
    private final long maxSize;

    private void putWindowIndex(int pageId, int windowIndex) {
        if (this.idToWindowIndex != null && pageId != -1 && windowIndex != -1) {
            Integer oldPageId = this.windowIndexToPageId.remove(windowIndex);
            if (oldPageId != null) {
                this.idToWindowIndex.remove(oldPageId);
            }
            this.idToWindowIndex.put(pageId, windowIndex);
            this.windowIndexToPageId.put(windowIndex, pageId);
        }
    }

    private void removeWindowIndex(int pageId) {
        Integer windowIndex = this.idToWindowIndex.remove(pageId);
        if (windowIndex != null) {
            this.windowIndexToPageId.remove(windowIndex);
        }
    }

    private void rebuildIndices() {
        this.idToWindowIndex = null;
        this.idToWindowIndex = new IntHashMap();
        this.windowIndexToPageId = null;
        this.windowIndexToPageId = new IntHashMap();
        for (int i = 0; i < this.windows.size(); ++i) {
            FileWindow window = this.windows.get(i);
            this.putWindowIndex(window.id, i);
        }
    }

    private int getWindowIndex(int pageId) {
        Integer result;
        if (this.idToWindowIndex == null) {
            this.rebuildIndices();
        }
        return (result = this.idToWindowIndex.get(pageId)) != null ? result : -1;
    }

    private int incrementIndexPointer() {
        this.indexPointer = this.maxSize > 0L && (long)this.totalSize >= this.maxSize && this.indexPointer == this.windows.size() - 1 ? 0 : ++this.indexPointer;
        return this.indexPointer;
    }

    private int getWindowFileOffset(int index) {
        if (index > 0) {
            FileWindow window = this.windows.get(index - 1);
            return window.filePartOffset + window.filePartSize;
        }
        return 0;
    }

    private void splitWindow(int index, int size) {
        FileWindow window = this.windows.get(index);
        int delta = window.filePartSize - size;
        if (index == this.windows.size() - 1) {
            this.totalSize -= delta;
            window.filePartSize = size;
        } else if (window.filePartSize != size) {
            FileWindow newWindow = new FileWindow();
            newWindow.id = -1;
            window.filePartSize = size;
            this.windows.add(index + 1, newWindow);
            newWindow.filePartOffset = this.getWindowFileOffset(index + 1);
            newWindow.filePartSize = delta;
        }
        this.idToWindowIndex = null;
        this.windowIndexToPageId = null;
    }

    private void mergeWindowWithNext(int index) {
        if (index < this.windows.size() - 1) {
            FileWindow window = this.windows.get(index);
            FileWindow next = this.windows.get(index + 1);
            window.filePartSize += next.filePartSize;
            this.windows.remove(index + 1);
            this.idToWindowIndex = null;
            this.windowIndexToPageId = null;
        }
    }

    private void adjustWindowSize(int index, int size) {
        FileWindow window = this.windows.get(index);
        if (index == this.windows.size() - 1) {
            int delta = size - window.filePartSize;
            this.totalSize += delta;
            window.filePartSize = size;
        } else {
            while (window.filePartSize < size && index < this.windows.size() - 1) {
                this.mergeWindowWithNext(index);
            }
            if (window.filePartSize < size) {
                int delta = size - window.filePartSize;
                this.totalSize += delta;
                window.filePartSize = size;
            } else {
                this.splitWindow(index, size);
            }
        }
        window.id = -1;
    }

    private FileWindow allocatePageWindow(int index, int size) {
        FileWindow window;
        if (index == this.windows.size()) {
            window = new FileWindow();
            window.filePartOffset = this.getWindowFileOffset(index);
            this.totalSize += size;
            window.filePartSize = size;
            this.windows.add(window);
        } else {
            window = this.windows.get(index);
            if (window.filePartSize != size) {
                this.adjustWindowSize(index, size);
            }
        }
        return window;
    }

    public synchronized FileWindow createPageWindow(int pageId, String pageType, int size) {
        int index = this.getWindowIndex(pageId);
        if (index != -1) {
            this.removeWindowIndex(pageId);
            this.windows.get((int)index).id = -1;
        }
        if (index == -1 || index != this.indexPointer) {
            index = this.incrementIndexPointer();
        }
        FileWindow window = this.allocatePageWindow(index, size);
        window.id = pageId;
        window.type = pageType;
        this.putWindowIndex(pageId, index);
        return window;
    }

    public synchronized FileWindow getPageWindow(int pageId) {
        int index = this.getWindowIndex(pageId);
        if (index != -1) {
            return this.windows.get(index);
        }
        return null;
    }

    public synchronized void removePage(int pageId) {
        int index = this.getWindowIndex(pageId);
        if (index != -1) {
            FileWindow window = this.windows.get(index);
            this.removeWindowIndex(pageId);
            if (index == this.windows.size() - 1) {
                this.windows.remove(index);
                this.totalSize -= window.filePartSize;
                if (this.indexPointer == index) {
                    --this.indexPointer;
                }
            } else {
                window.id = -1;
            }
        }
    }

    public synchronized List<FileWindow> getFileWindows() {
        ArrayList<FileWindow> result = new ArrayList<FileWindow>();
        int currentIndex = this.indexPointer;
        while (currentIndex != -1) {
            if (currentIndex < this.windows.size()) {
                FileWindow window = this.windows.get(currentIndex);
                if (window.id != -1) {
                    result.add(window);
                }
            }
            if (--currentIndex == -1) {
                currentIndex = this.windows.size() - 1;
            }
            if (currentIndex != this.indexPointer) continue;
        }
        return result;
    }

    public PageWindowManager(long maxSize) {
        this.maxSize = maxSize;
    }

    public synchronized int getTotalSize() {
        return this.totalSize;
    }

    public static class FileWindow
    implements IPersistedPage,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int id;
        private String type;
        private int filePartOffset;
        private int filePartSize;

        @Override
        public int getPageId() {
            return this.id;
        }

        @Override
        public String getPageType() {
            return this.type;
        }

        @Override
        public Bytes getPageSize() {
            return Bytes.bytes(this.filePartSize);
        }

        public int getFilePartOffset() {
            return this.filePartOffset;
        }

        public int getFilePartSize() {
            return this.filePartSize;
        }
    }
}

