/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.injection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.util.collections.ClassMetaCache;

public abstract class Injector {
    private static final MetaDataKey<Injector> KEY = new MetaDataKey<Injector>(){
        private static final long serialVersionUID = 1L;
    };
    private final ClassMetaCache<Field[]> cache = new ClassMetaCache();

    public void bind(Application application) {
        application.setMetaData(KEY, (Object)this);
    }

    public static Injector get() {
        return (Injector)Application.get().getMetaData(KEY);
    }

    public abstract void inject(Object var1);

    protected void inject(Object object, IFieldValueFactory factory) {
        Class<?> clazz = object.getClass();
        Field[] fields = null;
        fields = (Field[])this.cache.get(clazz);
        if (fields == null) {
            fields = this.findFields(clazz, factory);
            this.cache.put(clazz, (Object)fields);
        }
        for (Field field : fields) {
            if (!field.canAccess(object)) {
                field.setAccessible(true);
            }
            try {
                Object value;
                if (field.get(object) != null || (value = factory.getFieldValue(field, object)) == null) continue;
                field.set(object, value);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("error while injecting object [" + object.toString() + "] of type [" + object.getClass().getName() + "]", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("error while injecting object [" + object.toString() + "] of type [" + object.getClass().getName() + "]", e);
            }
        }
    }

    private Field[] findFields(Class<?> clazz, IFieldValueFactory factory) {
        ArrayList<Field> matched = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!factory.supportsField(field)) continue;
                matched.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return matched.toArray(new Field[matched.size()]);
    }
}

