/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractDialogMultiColTable
extends AbstractDialog {
    protected static final String UNCHECKED = "";
    Table table;
    protected boolean enableCol1 = true;
    protected boolean enableCol2 = true;
    protected int numberChecked = 0;

    protected String checkedIndicator(int col) {
        if (col == 1) {
            return "In";
        }
        return "Out";
    }

    protected AbstractDialogMultiColTable(AbstractSection aSection, String title, String description) {
        super(aSection, title, description);
    }

    @Override
    public void handleEvent(Event event) {
        if (event.type == 3 && event.widget == this.table) {
            Point mousePosition = new Point(event.x, event.y);
            TableItem item = this.table.getItem(mousePosition);
            if (null == item) {
                this.jitHowTo(event.widget);
                return;
            }
            int col = this.getHitColumn(item, mousePosition);
            if (col != 1 && col != 2) {
                this.jitHowTo(event.widget);
                return;
            }
            if (col == 1 && !this.enableCol1) {
                this.setErrorMessage("This resource can't be marked as input");
                return;
            }
            if (col == 2 && !this.enableCol2) {
                this.setErrorMessage("This resource can't be marked as output");
                return;
            }
            this.errorMessageUI.setText(UNCHECKED);
            this.toggleValue(item, col);
        }
        super.handleEvent(event);
    }

    private void jitHowTo(Widget w) {
        Utility.popMessage(w, "Where to mouse click", "Please click the mouse in the input or output columns to toggle the selection.", 2);
    }

    protected void toggleValue(TableItem item, int col) {
        item.setText(col, item.getText(col).equals(this.checkedIndicator(col)) ? UNCHECKED : this.checkedIndicator(col));
        this.numberChecked = item.getText(col).equals(this.checkedIndicator(col)) ? ++this.numberChecked : --this.numberChecked;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void enableOK() {
        this.errorMessageUI.setText(UNCHECKED);
        this.okButton.setEnabled(this.numberChecked > 0);
    }

    protected void setChecked(TableItem item, int col, boolean value) {
        boolean prevChecked = this.checkedIndicator(col).equals(item.getText(col));
        item.setText(col, value ? this.checkedIndicator(col) : UNCHECKED);
        if (value && !prevChecked) {
            ++this.numberChecked;
        } else if (!value && prevChecked) {
            --this.numberChecked;
        }
    }
}

