/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.internal.cde.uima.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLizable;
import org.eclipse.core.resources.IFile;

public class UimaDescriptionUtils {
    private static URL urlForResourceSpecifierSchema;

    public static XMLizable parseDescriptor(XMLInputSource input) throws InvalidXMLException {
        XMLParser.ParsingOptions parsingOptions = new XMLParser.ParsingOptions(false);
        XMLParser parser = UIMAFramework.getXMLParser();
        return parser.parse(input, "http://uima.apache.org/resourceSpecifier", urlForResourceSpecifierSchema, parsingOptions);
    }

    public static Import createByLocationImport(IFile parentFile, String location) throws MalformedURLException {
        String sDescriptorRelativePath = UimaDescriptionUtils.getDescriptorRelativePath(parentFile.getLocation().toString(), location);
        if (sDescriptorRelativePath.indexOf("file:/") == -1 && sDescriptorRelativePath.indexOf(":/") > -1) {
            sDescriptorRelativePath = "file:/" + sDescriptorRelativePath;
        }
        Import_impl imp = new Import_impl();
        URL url = new File(UimaDescriptionUtils.extractDirectory(parentFile)).toURL();
        imp.setSourceUrl(url);
        imp.setLocation(sDescriptorRelativePath);
        return imp;
    }

    public static Import createByNameImport(String fileName, ResourceManager rm) {
        if (fileName.endsWith(".xml")) {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        fileName = fileName.replace('\\', '/');
        int i = (fileName = fileName.replace('/', '.')).indexOf(":");
        if (i >= 0) {
            fileName = fileName.substring(i + 1);
        }
        if (fileName.charAt(0) == '.') {
            fileName = fileName.substring(1);
        }
        int partStart = 0;
        Import imp = UIMAFramework.getResourceSpecifierFactory().createImport();
        while (true) {
            imp.setName(fileName.substring(partStart));
            try {
                imp.findAbsoluteUrl(rm);
            }
            catch (InvalidXMLException e) {
                if (0 != (partStart = fileName.indexOf(46, partStart) + 1)) continue;
                return imp;
            }
            break;
        }
        return imp;
    }

    public static String getDescriptorFromImport(Import imp) {
        String descr = null;
        if (imp != null && (descr = imp.getLocation()) == null) {
            descr = imp.getName();
        }
        return descr;
    }

    public static String extractDirectory(IFile file) {
        String sDir = file.getParent().getLocation().toString();
        if (sDir.charAt(sDir.length() - 1) != '/') {
            sDir = sDir + '/';
        }
        return sDir;
    }

    public static String getDescriptorRelativePath(String sParentFileFullPath, String aFullOrRelativePath) {
        String sFullOrRelativePath = aFullOrRelativePath.replace('\\', '/');
        String sFullPath = sFullOrRelativePath;
        String commonPrefix = UimaDescriptionUtils.getCommonParentFolder(sParentFileFullPath, sFullPath);
        if (commonPrefix.length() < 2 || commonPrefix.indexOf(58) == commonPrefix.length() - 2) {
            return sFullPath;
        }
        int nCountBackDirs = 0;
        String sRelativePath = "";
        for (int i = commonPrefix.length(); i < sParentFileFullPath.length(); ++i) {
            if (sParentFileFullPath.charAt(i) != '/') continue;
            sRelativePath = sRelativePath + "../";
            ++nCountBackDirs;
        }
        sRelativePath = sRelativePath + sFullPath.substring(commonPrefix.length());
        return sRelativePath;
    }

    private static String getCommonParentFolder(String sFile1, String sFile2) {
        if (sFile1 == null || sFile2 == null) {
            return "";
        }
        int maxLength = sFile1.length() <= sFile2.length() ? sFile1.length() : sFile2.length();
        int commonPrefixLength = 0;
        block0: for (int i = 0; i < maxLength; ++i) {
            if (sFile1.charAt(i) == sFile2.charAt(i) && i != maxLength - 1) continue;
            for (int j = i; j >= 0; --j) {
                if (sFile1.charAt(j) != '/' && sFile1.charAt(j) != '\\') continue;
                commonPrefixLength = j + 1;
                break block0;
            }
            break;
        }
        return sFile1.substring(0, commonPrefixLength);
    }

    static {
        try {
            urlForResourceSpecifierSchema = new URL("file:resourceSpecifierSchema.xsd");
        }
        catch (MalformedURLException e) {
            urlForResourceSpecifierSchema = null;
        }
    }
}

