package org.apache.fulcrum.security.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.om.mapper.CompositeMapper;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.map.TableMap;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;



/**
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Fri Jan 03 13:59:32 CET 2025]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TorqueDynamicUserGroupPeer
 */

@SuppressWarnings("unused")
public abstract class BaseTorqueDynamicUserGroupPeerImpl
    extends org.apache.torque.util.AbstractPeerImpl<TorqueDynamicUserGroup>
{
    /** Serial version */
    private static final long serialVersionUID = 1735909172431L;



    /**
     * Constructor.
     * The recordMapper, tableMap and databaseName fields are correctly
     * initialized.
     */
    public BaseTorqueDynamicUserGroupPeerImpl()
    {
        this(new TorqueDynamicUserGroupRecordMapper(),
            TorqueDynamicUserGroupPeer.TABLE,
            TorqueDynamicUserGroupPeer.DATABASE_NAME);
    }

    /**
     * Constructor providing the objects to be injected as parameters.
     *
     * @param recordMapper a record mapper to map JDBC result sets to objects
     * @param tableMap the default table map
     * @param databaseName the name of the database
     */
    public BaseTorqueDynamicUserGroupPeerImpl(
            RecordMapper<TorqueDynamicUserGroup> recordMapper, 
            TableMap tableMap,
            String databaseName)
    {
        super(recordMapper, tableMap, databaseName);
    }


    /**
     * Returns a new instance of the Data object class
     */
    public TorqueDynamicUserGroup getDbObjectInstance()
    {
        return new TorqueDynamicUserGroup();
    }


    /**
     * Method to do updates.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Criteria) method.
     *
     * @param columnValues the values to update plus the primary key
     *        identifying the row to update.
     * @param con the connection to use, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doUpdate(ColumnValues columnValues, Connection con)
        throws TorqueException
    {
        Criteria selectCriteria = new Criteria(getDatabaseName());
        correctBooleans(columnValues);

        {
            JdbcTypedValue pkValue
                = columnValues.remove(TorqueDynamicUserGroupPeer.USER_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TorqueDynamicUserGroupPeer.USER_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TorqueDynamicUserGroupPeer.USER_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TorqueDynamicUserGroupPeer.USER_ID,
                        pkValue.getSqlExpression());
            }
        }
        {
            JdbcTypedValue pkValue
                = columnValues.remove(TorqueDynamicUserGroupPeer.GROUP_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TorqueDynamicUserGroupPeer.GROUP_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TorqueDynamicUserGroupPeer.GROUP_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TorqueDynamicUserGroupPeer.GROUP_ID,
                        pkValue.getSqlExpression());
            }
        }


        int rowCount = doUpdate(selectCriteria, columnValues, con);
        return rowCount;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     *
     * @param obj the data object to delete in the database, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TorqueDynamicUserGroup obj) throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()));
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     * This method is to be used during a transaction, otherwise use the
     * doDelete(TorqueDynamicUserGroup) method.
     *
     * @param obj the data object to delete in the database, not null.
     * @param con the connection to use, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TorqueDynamicUserGroup obj, Connection con)
        throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()), con);
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     *
     * @param objects the data object to delete in the database, not null,
     *        may not contain null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(Collection<TorqueDynamicUserGroup> objects)
            throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects));
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param objects the data objects to delete in the database, not null,
     *        may not contain null.
     * @param con the connection to use for deleting, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(
            Collection<TorqueDynamicUserGroup> objects,
            Connection con)
        throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects), con);
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /** 
     * Build a Criteria object which selects all objects which have a given
     * primary key.
     *
     * @param pk the primary key value to build the criteria from, not null.
     */
    public Criteria buildCriteria(ObjectKey<?> pk)
    {
        Criteria criteria = new Criteria();
        SimpleKey<?>[] keys = (SimpleKey[])pk.getValue();
        criteria.and(TorqueDynamicUserGroupPeer.USER_ID, keys[0]);
        criteria.and(TorqueDynamicUserGroupPeer.GROUP_ID, keys[1]);
        return criteria;
     }

    /** 
     * Build a Criteria object which selects all objects which primary keys
     * are contained in the passed collection.
     *
     * @param pks the primary key values to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildCriteria(Collection<ObjectKey<?>> pks)
    {
        Criteria criteria = new Criteria();
        for (ObjectKey<?> pk : pks)
        {
            SimpleKey<?>[] keys = (SimpleKey[])pk.getValue();
                Criterion c0 = new Criterion(
                    TorqueDynamicUserGroupPeer.USER_ID, keys[0], Criteria.EQUAL);
                Criterion c1 = new Criterion(
                    TorqueDynamicUserGroupPeer.GROUP_ID, keys[1], Criteria.EQUAL);
                    c0.and(c1);
            criteria.or(c0);
        }
        return criteria;
     }


    /** 
     * Build a Criteria object which selects all passed objects using their
     * primary key. Objects which do not yet have a primary key are ignored.
     *
     * @param objects the objects to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildPkCriteria(
            Collection<TorqueDynamicUserGroup> objects)
    {
        return buildCriteria(objects.stream()
                .map(object -> object.getPrimaryKey())
                .collect(Collectors.toList()));
    }

    /** 
     * Build a Criteria object from the data object for this peer.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildCriteria(TorqueDynamicUserGroup obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        criteria.and(TorqueDynamicUserGroupPeer.USER_ID, obj.getUserId());
        criteria.and(TorqueDynamicUserGroupPeer.GROUP_ID, obj.getGroupId());
        return criteria;
    }

    /** 
     * Build a Criteria object from the data object for this peer,
     * skipping all binary columns.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildSelectCriteria(TorqueDynamicUserGroup obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        criteria.and(TorqueDynamicUserGroupPeer.USER_ID, obj.getUserId());
        criteria.and(TorqueDynamicUserGroupPeer.GROUP_ID, obj.getGroupId());
        return criteria;
    }

    /** 
     * Returns the contents of the object as ColumnValues object.
     * Primary key columns which are generated on insertion are not
     * added to the returned object if they still have their initial
     * value. Also, columns which have the useDatabaseDefaultValue
     * flag set to true are also not added to the returned object
     * if they still have their initial value.
     *
     * @throws TorqueException if the table map cannot be retrieved
     *         (should not happen).
     */
    public ColumnValues buildColumnValues(TorqueDynamicUserGroup torqueDynamicUserGroup)
            throws TorqueException
    {
        ColumnValues columnValues = new ColumnValues();
        columnValues.put(
                TorqueDynamicUserGroupPeer.USER_ID,
                new JdbcTypedValue(
                    torqueDynamicUserGroup.getUserId(),
                    4));
        columnValues.put(
                TorqueDynamicUserGroupPeer.GROUP_ID,
                new JdbcTypedValue(
                    torqueDynamicUserGroup.getGroupId(),
                    4));
        return columnValues;
    }

    /**
     * retrieve object using using pk values.
     *
     * @param userId Integer
     * @param groupId Integer
     */
    public TorqueDynamicUserGroup retrieveByPK(
            Integer userId,
            Integer groupId)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TorqueDynamicUserGroup result = retrieveByPK(
               userId,
               groupId,
               connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * retrieve object using using pk values.
     *
     * @param userId Integer
     * @param groupId Integer
     * @param con Connection
     */
    public TorqueDynamicUserGroup retrieveByPK(
            Integer userId,
            Integer groupId,
            Connection con) throws TorqueException
    {

        Criteria criteria = new Criteria();
        criteria.and(TorqueDynamicUserGroupPeer.USER_ID, userId);
        criteria.and(TorqueDynamicUserGroupPeer.GROUP_ID, groupId);
        TorqueDynamicUserGroup v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueDynamicUserGroup retrieveByPK(ObjectKey<?> pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TorqueDynamicUserGroup result = retrieveByPK(pk, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueDynamicUserGroup retrieveByPK(ObjectKey<?> pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        Criteria criteria = buildCriteria(pk);
        TorqueDynamicUserGroup v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }


    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueDynamicUserGroup> retrieveByObjectKeys(Collection<ObjectKey<?>> pks)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueDynamicUserGroup> result = retrieveByObjectKeys(pks, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     * @param dbcon the connection to use
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueDynamicUserGroup> retrieveByObjectKeys(
                Collection<ObjectKey<?>> pks,
                Connection dbcon)
            throws TorqueException
    {
        if (pks == null || pks.size() == 0)
        {
            return new ArrayList<TorqueDynamicUserGroup>();
        }
        Criteria criteria = buildCriteria(pks);
        List<TorqueDynamicUserGroup> result = doSelect(criteria, dbcon);
        return result;
    }


    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TorqueDynamicUser objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueDynamicUserGroup> doSelectJoinTorqueDynamicUser(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueDynamicUserGroup> result
                    = TorqueDynamicUserGroupPeer.doSelectJoinTorqueDynamicUser(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TorqueDynamicUserGroup objects pre-filled with their
     * TorqueDynamicUser objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueDynamicUserGroup> doSelectJoinTorqueDynamicUser(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TorqueDynamicUserPeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TorqueDynamicUserGroupRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TorqueDynamicUserRecordMapper(),
                TorqueDynamicUserGroupPeer.numColumns);
        criteria.addJoin(TorqueDynamicUserGroupPeer.USER_ID,
            org.apache.fulcrum.security.torque.om.TorqueDynamicUserPeer.USER_ID);

        correctBooleans(criteria);

        List<TorqueDynamicUserGroup> result = new ArrayList<TorqueDynamicUserGroup>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueDynamicUserGroup obj1 = (TorqueDynamicUserGroup) rawResultRow.get(0);
            TorqueDynamicUser obj2 = (TorqueDynamicUser) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TorqueDynamicUserGroup temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueDynamicUser temp_obj2 = temp_obj1.getTorqueDynamicUser();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueDynamicUserGroup(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueDynamicUserGroups();
                obj2.addTorqueDynamicUserGroup(obj1);
            }
            result.add(obj1);
        }
        return result;
    }
    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TorqueDynamicGroup objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueDynamicUserGroup> doSelectJoinTorqueDynamicGroup(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueDynamicUserGroup> result
                    = TorqueDynamicUserGroupPeer.doSelectJoinTorqueDynamicGroup(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TorqueDynamicUserGroup objects pre-filled with their
     * TorqueDynamicGroup objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueDynamicUserGroup> doSelectJoinTorqueDynamicGroup(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TorqueDynamicGroupPeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TorqueDynamicUserGroupRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TorqueDynamicGroupRecordMapper(),
                TorqueDynamicUserGroupPeer.numColumns);
        criteria.addJoin(TorqueDynamicUserGroupPeer.GROUP_ID,
            org.apache.fulcrum.security.torque.om.TorqueDynamicGroupPeer.GROUP_ID);

        correctBooleans(criteria);

        List<TorqueDynamicUserGroup> result = new ArrayList<TorqueDynamicUserGroup>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueDynamicUserGroup obj1 = (TorqueDynamicUserGroup) rawResultRow.get(0);
            TorqueDynamicGroup obj2 = (TorqueDynamicGroup) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TorqueDynamicUserGroup temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueDynamicGroup temp_obj2 = temp_obj1.getTorqueDynamicGroup();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueDynamicUserGroup(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueDynamicUserGroups();
                obj2.addTorqueDynamicUserGroup(obj1);
            }
            result.add(obj1);
        }
        return result;
    }




}
