/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.descriptor;

import jakarta.validation.metadata.CascadableDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.ContainerDescriptor;
import jakarta.validation.metadata.ContainerElementTypeDescriptor;
import jakarta.validation.metadata.ElementDescriptor;
import jakarta.validation.metadata.GroupConversionDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.bval.jsr.descriptor.CascadableContainerD;
import org.apache.bval.jsr.descriptor.ElementD;
import org.apache.bval.jsr.descriptor.Finder;
import org.apache.bval.jsr.descriptor.PropertyD;
import org.apache.bval.jsr.groups.GroupsComputer;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.util.Validate;

public abstract class ComposedD<D extends ElementD<?, ?>>
implements ElementDescriptor {
    protected final List<D> delegates;

    public static <T extends ElementD<?, ?>> Stream<T> unwrap(ElementDescriptor descriptor, Class<T> delegateType) {
        Stream<Object> s = descriptor instanceof ComposedD ? ((ComposedD)descriptor).delegates.stream().flatMap(d -> ComposedD.unwrap(d, delegateType)) : Stream.of(descriptor);
        return s.map(delegateType::cast);
    }

    ComposedD(List<D> delegates) {
        this.delegates = delegates;
        Validate.notNull(delegates, "delegates", new Object[0]);
        Validate.isTrue(!delegates.isEmpty(), "At least one delegate is required", new Object[0]);
        Validate.isTrue(delegates.stream().noneMatch(Objects::isNull), "null delegates not permitted", new Object[0]);
    }

    public boolean hasConstraints() {
        return this.delegates.stream().anyMatch(ElementDescriptor::hasConstraints);
    }

    public Class<?> getElementClass() {
        return this.delegates.stream().map(ElementDescriptor::getElementClass).findFirst().orElseThrow(IllegalStateException::new);
    }

    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return this.delegates.stream().map(ElementDescriptor::getConstraintDescriptors).flatMap(Collection::stream).collect(ToUnmodifiable.set());
    }

    public ElementDescriptor.ConstraintFinder findConstraints() {
        GroupsComputer groupsComputer = ComposedD.unwrap((ElementDescriptor)this, ElementD.class).findFirst().orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/IllegalStateException;)()).groupsComputer;
        return new Finder(groupsComputer, this);
    }

    static class ForProperty
    extends ForCascadableContainer<PropertyD<?>>
    implements PropertyDescriptor {
        ForProperty(List<PropertyD<?>> delegates) {
            super(delegates);
        }

        public String getPropertyName() {
            return this.delegates.stream().map(PropertyDescriptor::getPropertyName).findFirst().orElseThrow(IllegalStateException::new);
        }
    }

    static abstract class ForCascadableContainer<D extends CascadableContainerD<?, ?>>
    extends ComposedD<D>
    implements CascadableDescriptor,
    ContainerDescriptor {
        ForCascadableContainer(List<D> delegates) {
            super(delegates);
        }

        public Set<ContainerElementTypeDescriptor> getConstrainedContainerElementTypes() {
            return this.delegates.stream().map(ContainerDescriptor::getConstrainedContainerElementTypes).flatMap(Collection::stream).collect(ToUnmodifiable.set());
        }

        public boolean isCascaded() {
            return this.delegates.stream().anyMatch(CascadableDescriptor::isCascaded);
        }

        public Set<GroupConversionDescriptor> getGroupConversions() {
            return this.delegates.stream().map(CascadableDescriptor::getGroupConversions).flatMap(Collection::stream).collect(ToUnmodifiable.set());
        }
    }
}

