/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util.executor;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.util.Duration;

public class OfferRejectedExecutionHandler
implements RejectedExecutionHandler {
    private long timeout = 30L;
    private TimeUnit seconds = TimeUnit.SECONDS;

    public OfferRejectedExecutionHandler(Duration duration) {
        this(duration.getTime(), duration.getUnit() == null ? TimeUnit.SECONDS : duration.getUnit());
    }

    public OfferRejectedExecutionHandler(long timeout, TimeUnit timeUnit) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout must be greater than zero");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("TimeUnit must not be null");
        }
        this.timeout = timeout;
        this.seconds = timeUnit;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor tpe) {
        if (null == r || null == tpe || tpe.isShutdown() || tpe.isTerminated() || tpe.isTerminating()) {
            return;
        }
        try {
            if (!tpe.getQueue().offer(r, this.timeout, this.seconds)) {
                throw new RejectedExecutionException("Timeout waiting for executor slot: waited " + this.timeout + " " + this.seconds.toString().toLowerCase());
            }
        }
        catch (InterruptedException e) {
            throw new RejectedExecutionException("Interrupted waiting for executor slot");
        }
    }
}

