/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy;

import java.io.Serializable;
import java.util.Collections;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class TraversalStrategyProxy<T extends TraversalStrategy>
implements Serializable,
TraversalStrategy {
    private final Configuration configuration;
    private final String strategyName;

    public TraversalStrategyProxy(String strategyName) {
        this(strategyName, (Configuration)new MapConfiguration(Collections.EMPTY_MAP));
    }

    public TraversalStrategyProxy(String strategyName, Configuration configuration) {
        this.configuration = configuration;
        this.strategyName = strategyName;
    }

    public TraversalStrategyProxy(T traversalStrategy) {
        this(traversalStrategy.getClass().getSimpleName(), traversalStrategy.getConfiguration());
    }

    @Deprecated
    public TraversalStrategyProxy(Class<T> strategyClass, Configuration configuration) {
        this(strategyClass.getSimpleName(), configuration);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    @Deprecated
    public Class<T> getStrategyClass() {
        return TraversalStrategies.GlobalCache.getRegisteredStrategyClass(this.strategyName).get();
    }

    public void apply(Traversal.Admin traversal) {
        throw new UnsupportedOperationException("TraversalStrategyProxy is not meant to be used directly as a TraversalStrategy and is for serialization purposes only");
    }

    @Override
    public int compareTo(Object o) {
        throw new UnsupportedOperationException("TraversalStrategyProxy is not meant to be used directly as a TraversalStrategy and is for serialization purposes only");
    }

    public String toString() {
        return StringFactory.traversalStrategyProxyString(this);
    }
}

