/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.TenantPersonAttributeDaoBuilder;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.persondir.PersonDirectoryUtils;
import org.apereo.cas.persondir.TenantRestfulPersonAttributeDaoBuilder;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PersonDirectory}, module="rest")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="CasPersonDirectoryRestConfiguration", proxyBeanMethods=false)
class CasPersonDirectoryRestConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryRestConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.attribute-repository.rest[0].url").isUrl();

    CasPersonDirectoryRestConfiguration() {
    }

    @Configuration(value="RestfulAttributeRepositoryMultitenancyConfiguration", proxyBeanMethods=false)
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Multitenancy})
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class RestfulAttributeRepositoryMultitenancyConfiguration {
        RestfulAttributeRepositoryMultitenancyConfiguration() {
        }

        @ConditionalOnMissingBean(name={"restfulTenantPersonAttributeDaoBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TenantPersonAttributeDaoBuilder restfulTenantPersonAttributeDaoBuilder(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (TenantPersonAttributeDaoBuilder)BeanSupplier.of(TenantPersonAttributeDaoBuilder.class).when(BeanCondition.on((String)"cas.multitenancy.core.enabled").isTrue().given((ApplicationContext)applicationContext)).supply(TenantRestfulPersonAttributeDaoBuilder::new).otherwise(TenantPersonAttributeDaoBuilder::noOp).get();
        }
    }

    @Configuration(value="RestfulAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class RestfulAttributeRepositoryPlanConfiguration {
        RestfulAttributeRepositoryPlanConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"restfulPersonDirectoryAttributeRepositoryPlanConfigurer"})
        public PersonDirectoryAttributeRepositoryPlanConfigurer restfulPersonDirectoryAttributeRepositoryPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="restfulAttributeRepositories") BeanContainer<PersonAttributeDao> restfulAttributeRepositories) {
            return (PersonDirectoryAttributeRepositoryPlanConfigurer)BeanSupplier.of(PersonDirectoryAttributeRepositoryPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                List results = restfulAttributeRepositories.toList().stream().filter(PersonAttributeDao::isEnabled).collect(Collectors.toList());
                plan.registerAttributeRepositories(results);
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="RestfulAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class RestfulAttributeRepositoryConfiguration {
        RestfulAttributeRepositoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"restfulAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<PersonAttributeDao> restfulAttributeRepositories(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                List rest = casProperties.getAuthn().getAttributeRepository().getRest();
                List list = PersonDirectoryUtils.newRestAttributeRepository((List)rest);
                return BeanContainer.of((List)list);
            }).otherwise(BeanContainer::empty).get();
        }
    }
}

