/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import org.apereo.cas.authentication.attribute.TenantPersonAttributeDaoBuilder;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.syncope.SyncopeUtils;
import org.apereo.cas.syncope.TenantSyncopePersonAttributeDaoBuilder;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PersonDirectory}, module="syncope")
@Configuration(value="SyncopePersonDirectoryConfiguration", proxyBeanMethods=false)
class SyncopePersonDirectoryConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.attribute-repository.syncope.url").isUrl();

    SyncopePersonDirectoryConfiguration() {
    }

    @ConditionalOnMissingBean(name={"syncopePersonAttributeDaos"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public BeanContainer<PersonAttributeDao> syncopePersonAttributeDaos(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            List<? extends PersonAttributeDao> repositories = SyncopeUtils.newPersonAttributeDaos(casProperties.getAuthn().getAttributeRepository().getSyncope());
            return BeanContainer.of(repositories);
        }).otherwise(BeanContainer::empty).get();
    }

    @ConditionalOnMissingBean(name={"syncopeAttributeRepositoryPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PersonDirectoryAttributeRepositoryPlanConfigurer syncopeAttributeRepositoryPlanConfigurer(@Qualifier(value="syncopePersonAttributeDaos") BeanContainer<PersonAttributeDao> syncopePersonAttributeDaos) {
        return plan -> syncopePersonAttributeDaos.toList().stream().filter(PersonAttributeDao::isEnabled).forEach(arg_0 -> ((PersonDirectoryAttributeRepositoryPlan)plan).registerAttributeRepository(arg_0));
    }

    @Configuration(value="SyncopePersonDirectoryMultitenancyConfiguration", proxyBeanMethods=false)
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Multitenancy})
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SyncopePersonDirectoryMultitenancyConfiguration {
        SyncopePersonDirectoryMultitenancyConfiguration() {
        }

        @ConditionalOnMissingBean(name={"syncopeTenantPersonAttributeDaoBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TenantPersonAttributeDaoBuilder syncopeTenantPersonAttributeDaoBuilder(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (TenantPersonAttributeDaoBuilder)BeanSupplier.of(TenantPersonAttributeDaoBuilder.class).when(BeanCondition.on((String)"cas.multitenancy.core.enabled").isTrue().given((ApplicationContext)applicationContext)).supply(TenantSyncopePersonAttributeDaoBuilder::new).otherwise(TenantPersonAttributeDaoBuilder::noOp).get();
        }
    }
}

