/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.configuration.model.support.oauth.OAuthCoreProperties;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthAccessTokenExpirationPolicy;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthCodeExpirationPolicy;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthDeviceTokenExpirationPolicy;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthRefreshTokenExpirationPolicy;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthTokenExchangePolicy;

public class OAuthRegisteredService
extends BaseWebBasedRegisteredService {
    public static final String OAUTH_REGISTERED_SERVICE_FRIENDLY_NAME = "OAuth2 Client";
    private static final long serialVersionUID = 5318897374067731021L;
    private String clientSecret;
    private String clientId;
    private boolean bypassApprovalPrompt;
    private boolean generateRefreshToken;
    private boolean renewRefreshToken;
    private boolean jwtAccessToken;
    private boolean jwtRefreshToken;
    private String jwtAccessTokenSigningAlg;
    private Set<String> audience = new HashSet<String>();
    private RegisteredServiceOAuthCodeExpirationPolicy codeExpirationPolicy;
    private RegisteredServiceOAuthAccessTokenExpirationPolicy accessTokenExpirationPolicy;
    private RegisteredServiceOAuthRefreshTokenExpirationPolicy refreshTokenExpirationPolicy;
    private RegisteredServiceOAuthDeviceTokenExpirationPolicy deviceTokenExpirationPolicy;
    private RegisteredServiceOAuthTokenExchangePolicy tokenExchangePolicy;
    private Set<String> supportedGrantTypes = new HashSet<String>();
    private Set<String> supportedResponseTypes = new HashSet<String>();
    private OAuthCoreProperties.UserProfileViewTypes userProfileViewType;
    private Set<String> scopes = new HashSet<String>();
    private String responseMode;
    private String introspectionSignedResponseAlg = "RS512";
    private String introspectionEncryptedResponseAlg;
    private String introspectionEncryptedResponseEncoding;
    private String tokenEndpointAuthenticationMethod;
    private String tlsClientAuthSubjectDn;
    private String tlsClientAuthSanDns;
    private String tlsClientAuthSanUri;
    private String tlsClientAuthSanIp;
    private String tlsClientAuthSanEmail;

    @JsonIgnore
    public String getFriendlyName() {
        return OAUTH_REGISTERED_SERVICE_FRIENDLY_NAME;
    }

    @JsonIgnore
    public int getEvaluationPriority() {
        return 2;
    }

    public Set<String> getScopes() {
        if (this.scopes == null) {
            this.scopes = new HashSet<String>();
        }
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.getScopes().clear();
        this.getScopes().addAll(scopes);
    }

    public void initialize() {
        super.initialize();
        this.scopes = (Set)ObjectUtils.getIfNull(this.scopes, new HashSet());
        this.audience = (Set)ObjectUtils.getIfNull(this.audience, new HashSet());
    }

    @Generated
    public String toString() {
        return "OAuthRegisteredService(super=" + super.toString() + ", clientSecret=" + this.clientSecret + ", clientId=" + this.clientId + ", bypassApprovalPrompt=" + this.bypassApprovalPrompt + ", generateRefreshToken=" + this.generateRefreshToken + ", renewRefreshToken=" + this.renewRefreshToken + ", jwtAccessToken=" + this.jwtAccessToken + ", jwtRefreshToken=" + this.jwtRefreshToken + ", jwtAccessTokenSigningAlg=" + this.jwtAccessTokenSigningAlg + ", audience=" + String.valueOf(this.audience) + ", codeExpirationPolicy=" + String.valueOf(this.codeExpirationPolicy) + ", accessTokenExpirationPolicy=" + String.valueOf(this.accessTokenExpirationPolicy) + ", refreshTokenExpirationPolicy=" + String.valueOf(this.refreshTokenExpirationPolicy) + ", deviceTokenExpirationPolicy=" + String.valueOf(this.deviceTokenExpirationPolicy) + ", tokenExchangePolicy=" + String.valueOf(this.tokenExchangePolicy) + ", supportedGrantTypes=" + String.valueOf(this.supportedGrantTypes) + ", supportedResponseTypes=" + String.valueOf(this.supportedResponseTypes) + ", userProfileViewType=" + String.valueOf(this.userProfileViewType) + ", scopes=" + String.valueOf(this.scopes) + ", responseMode=" + this.responseMode + ", introspectionSignedResponseAlg=" + this.introspectionSignedResponseAlg + ", introspectionEncryptedResponseAlg=" + this.introspectionEncryptedResponseAlg + ", introspectionEncryptedResponseEncoding=" + this.introspectionEncryptedResponseEncoding + ", tokenEndpointAuthenticationMethod=" + this.tokenEndpointAuthenticationMethod + ", tlsClientAuthSubjectDn=" + this.tlsClientAuthSubjectDn + ", tlsClientAuthSanDns=" + this.tlsClientAuthSanDns + ", tlsClientAuthSanUri=" + this.tlsClientAuthSanUri + ", tlsClientAuthSanIp=" + this.tlsClientAuthSanIp + ", tlsClientAuthSanEmail=" + this.tlsClientAuthSanEmail + ")";
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public boolean isBypassApprovalPrompt() {
        return this.bypassApprovalPrompt;
    }

    @Generated
    public boolean isGenerateRefreshToken() {
        return this.generateRefreshToken;
    }

    @Generated
    public boolean isRenewRefreshToken() {
        return this.renewRefreshToken;
    }

    @Generated
    public boolean isJwtAccessToken() {
        return this.jwtAccessToken;
    }

    @Generated
    public boolean isJwtRefreshToken() {
        return this.jwtRefreshToken;
    }

    @Generated
    public String getJwtAccessTokenSigningAlg() {
        return this.jwtAccessTokenSigningAlg;
    }

    @Generated
    public Set<String> getAudience() {
        return this.audience;
    }

    @Generated
    public RegisteredServiceOAuthCodeExpirationPolicy getCodeExpirationPolicy() {
        return this.codeExpirationPolicy;
    }

    @Generated
    public RegisteredServiceOAuthAccessTokenExpirationPolicy getAccessTokenExpirationPolicy() {
        return this.accessTokenExpirationPolicy;
    }

    @Generated
    public RegisteredServiceOAuthRefreshTokenExpirationPolicy getRefreshTokenExpirationPolicy() {
        return this.refreshTokenExpirationPolicy;
    }

    @Generated
    public RegisteredServiceOAuthDeviceTokenExpirationPolicy getDeviceTokenExpirationPolicy() {
        return this.deviceTokenExpirationPolicy;
    }

    @Generated
    public RegisteredServiceOAuthTokenExchangePolicy getTokenExchangePolicy() {
        return this.tokenExchangePolicy;
    }

    @Generated
    public Set<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    @Generated
    public Set<String> getSupportedResponseTypes() {
        return this.supportedResponseTypes;
    }

    @Generated
    public OAuthCoreProperties.UserProfileViewTypes getUserProfileViewType() {
        return this.userProfileViewType;
    }

    @Generated
    public String getResponseMode() {
        return this.responseMode;
    }

    @Generated
    public String getIntrospectionSignedResponseAlg() {
        return this.introspectionSignedResponseAlg;
    }

    @Generated
    public String getIntrospectionEncryptedResponseAlg() {
        return this.introspectionEncryptedResponseAlg;
    }

    @Generated
    public String getIntrospectionEncryptedResponseEncoding() {
        return this.introspectionEncryptedResponseEncoding;
    }

    @Generated
    public String getTokenEndpointAuthenticationMethod() {
        return this.tokenEndpointAuthenticationMethod;
    }

    @Generated
    public String getTlsClientAuthSubjectDn() {
        return this.tlsClientAuthSubjectDn;
    }

    @Generated
    public String getTlsClientAuthSanDns() {
        return this.tlsClientAuthSanDns;
    }

    @Generated
    public String getTlsClientAuthSanUri() {
        return this.tlsClientAuthSanUri;
    }

    @Generated
    public String getTlsClientAuthSanIp() {
        return this.tlsClientAuthSanIp;
    }

    @Generated
    public String getTlsClientAuthSanEmail() {
        return this.tlsClientAuthSanEmail;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setBypassApprovalPrompt(boolean bypassApprovalPrompt) {
        this.bypassApprovalPrompt = bypassApprovalPrompt;
    }

    @Generated
    public void setGenerateRefreshToken(boolean generateRefreshToken) {
        this.generateRefreshToken = generateRefreshToken;
    }

    @Generated
    public void setRenewRefreshToken(boolean renewRefreshToken) {
        this.renewRefreshToken = renewRefreshToken;
    }

    @Generated
    public void setJwtAccessToken(boolean jwtAccessToken) {
        this.jwtAccessToken = jwtAccessToken;
    }

    @Generated
    public void setJwtRefreshToken(boolean jwtRefreshToken) {
        this.jwtRefreshToken = jwtRefreshToken;
    }

    @Generated
    public void setJwtAccessTokenSigningAlg(String jwtAccessTokenSigningAlg) {
        this.jwtAccessTokenSigningAlg = jwtAccessTokenSigningAlg;
    }

    @Generated
    public void setAudience(Set<String> audience) {
        this.audience = audience;
    }

    @Generated
    public void setCodeExpirationPolicy(RegisteredServiceOAuthCodeExpirationPolicy codeExpirationPolicy) {
        this.codeExpirationPolicy = codeExpirationPolicy;
    }

    @Generated
    public void setAccessTokenExpirationPolicy(RegisteredServiceOAuthAccessTokenExpirationPolicy accessTokenExpirationPolicy) {
        this.accessTokenExpirationPolicy = accessTokenExpirationPolicy;
    }

    @Generated
    public void setRefreshTokenExpirationPolicy(RegisteredServiceOAuthRefreshTokenExpirationPolicy refreshTokenExpirationPolicy) {
        this.refreshTokenExpirationPolicy = refreshTokenExpirationPolicy;
    }

    @Generated
    public void setDeviceTokenExpirationPolicy(RegisteredServiceOAuthDeviceTokenExpirationPolicy deviceTokenExpirationPolicy) {
        this.deviceTokenExpirationPolicy = deviceTokenExpirationPolicy;
    }

    @Generated
    public void setTokenExchangePolicy(RegisteredServiceOAuthTokenExchangePolicy tokenExchangePolicy) {
        this.tokenExchangePolicy = tokenExchangePolicy;
    }

    @Generated
    public void setSupportedGrantTypes(Set<String> supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
    }

    @Generated
    public void setSupportedResponseTypes(Set<String> supportedResponseTypes) {
        this.supportedResponseTypes = supportedResponseTypes;
    }

    @Generated
    public void setUserProfileViewType(OAuthCoreProperties.UserProfileViewTypes userProfileViewType) {
        this.userProfileViewType = userProfileViewType;
    }

    @Generated
    public void setResponseMode(String responseMode) {
        this.responseMode = responseMode;
    }

    @Generated
    public void setIntrospectionSignedResponseAlg(String introspectionSignedResponseAlg) {
        this.introspectionSignedResponseAlg = introspectionSignedResponseAlg;
    }

    @Generated
    public void setIntrospectionEncryptedResponseAlg(String introspectionEncryptedResponseAlg) {
        this.introspectionEncryptedResponseAlg = introspectionEncryptedResponseAlg;
    }

    @Generated
    public void setIntrospectionEncryptedResponseEncoding(String introspectionEncryptedResponseEncoding) {
        this.introspectionEncryptedResponseEncoding = introspectionEncryptedResponseEncoding;
    }

    @Generated
    public void setTokenEndpointAuthenticationMethod(String tokenEndpointAuthenticationMethod) {
        this.tokenEndpointAuthenticationMethod = tokenEndpointAuthenticationMethod;
    }

    @Generated
    public void setTlsClientAuthSubjectDn(String tlsClientAuthSubjectDn) {
        this.tlsClientAuthSubjectDn = tlsClientAuthSubjectDn;
    }

    @Generated
    public void setTlsClientAuthSanDns(String tlsClientAuthSanDns) {
        this.tlsClientAuthSanDns = tlsClientAuthSanDns;
    }

    @Generated
    public void setTlsClientAuthSanUri(String tlsClientAuthSanUri) {
        this.tlsClientAuthSanUri = tlsClientAuthSanUri;
    }

    @Generated
    public void setTlsClientAuthSanIp(String tlsClientAuthSanIp) {
        this.tlsClientAuthSanIp = tlsClientAuthSanIp;
    }

    @Generated
    public void setTlsClientAuthSanEmail(String tlsClientAuthSanEmail) {
        this.tlsClientAuthSanEmail = tlsClientAuthSanEmail;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthRegisteredService)) {
            return false;
        }
        OAuthRegisteredService other = (OAuthRegisteredService)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.bypassApprovalPrompt != other.bypassApprovalPrompt) {
            return false;
        }
        if (this.generateRefreshToken != other.generateRefreshToken) {
            return false;
        }
        if (this.renewRefreshToken != other.renewRefreshToken) {
            return false;
        }
        if (this.jwtAccessToken != other.jwtAccessToken) {
            return false;
        }
        if (this.jwtRefreshToken != other.jwtRefreshToken) {
            return false;
        }
        String this$clientSecret = this.clientSecret;
        String other$clientSecret = other.clientSecret;
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$clientId = this.clientId;
        String other$clientId = other.clientId;
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$jwtAccessTokenSigningAlg = this.jwtAccessTokenSigningAlg;
        String other$jwtAccessTokenSigningAlg = other.jwtAccessTokenSigningAlg;
        if (this$jwtAccessTokenSigningAlg == null ? other$jwtAccessTokenSigningAlg != null : !this$jwtAccessTokenSigningAlg.equals(other$jwtAccessTokenSigningAlg)) {
            return false;
        }
        Set<String> this$audience = this.audience;
        Set<String> other$audience = other.audience;
        if (this$audience == null ? other$audience != null : !((Object)this$audience).equals(other$audience)) {
            return false;
        }
        RegisteredServiceOAuthCodeExpirationPolicy this$codeExpirationPolicy = this.codeExpirationPolicy;
        RegisteredServiceOAuthCodeExpirationPolicy other$codeExpirationPolicy = other.codeExpirationPolicy;
        if (this$codeExpirationPolicy == null ? other$codeExpirationPolicy != null : !this$codeExpirationPolicy.equals(other$codeExpirationPolicy)) {
            return false;
        }
        RegisteredServiceOAuthAccessTokenExpirationPolicy this$accessTokenExpirationPolicy = this.accessTokenExpirationPolicy;
        RegisteredServiceOAuthAccessTokenExpirationPolicy other$accessTokenExpirationPolicy = other.accessTokenExpirationPolicy;
        if (this$accessTokenExpirationPolicy == null ? other$accessTokenExpirationPolicy != null : !this$accessTokenExpirationPolicy.equals(other$accessTokenExpirationPolicy)) {
            return false;
        }
        RegisteredServiceOAuthRefreshTokenExpirationPolicy this$refreshTokenExpirationPolicy = this.refreshTokenExpirationPolicy;
        RegisteredServiceOAuthRefreshTokenExpirationPolicy other$refreshTokenExpirationPolicy = other.refreshTokenExpirationPolicy;
        if (this$refreshTokenExpirationPolicy == null ? other$refreshTokenExpirationPolicy != null : !this$refreshTokenExpirationPolicy.equals(other$refreshTokenExpirationPolicy)) {
            return false;
        }
        RegisteredServiceOAuthDeviceTokenExpirationPolicy this$deviceTokenExpirationPolicy = this.deviceTokenExpirationPolicy;
        RegisteredServiceOAuthDeviceTokenExpirationPolicy other$deviceTokenExpirationPolicy = other.deviceTokenExpirationPolicy;
        if (this$deviceTokenExpirationPolicy == null ? other$deviceTokenExpirationPolicy != null : !this$deviceTokenExpirationPolicy.equals(other$deviceTokenExpirationPolicy)) {
            return false;
        }
        RegisteredServiceOAuthTokenExchangePolicy this$tokenExchangePolicy = this.tokenExchangePolicy;
        RegisteredServiceOAuthTokenExchangePolicy other$tokenExchangePolicy = other.tokenExchangePolicy;
        if (this$tokenExchangePolicy == null ? other$tokenExchangePolicy != null : !this$tokenExchangePolicy.equals(other$tokenExchangePolicy)) {
            return false;
        }
        Set<String> this$supportedGrantTypes = this.supportedGrantTypes;
        Set<String> other$supportedGrantTypes = other.supportedGrantTypes;
        if (this$supportedGrantTypes == null ? other$supportedGrantTypes != null : !((Object)this$supportedGrantTypes).equals(other$supportedGrantTypes)) {
            return false;
        }
        Set<String> this$supportedResponseTypes = this.supportedResponseTypes;
        Set<String> other$supportedResponseTypes = other.supportedResponseTypes;
        if (this$supportedResponseTypes == null ? other$supportedResponseTypes != null : !((Object)this$supportedResponseTypes).equals(other$supportedResponseTypes)) {
            return false;
        }
        OAuthCoreProperties.UserProfileViewTypes this$userProfileViewType = this.userProfileViewType;
        OAuthCoreProperties.UserProfileViewTypes other$userProfileViewType = other.userProfileViewType;
        if (this$userProfileViewType == null ? other$userProfileViewType != null : !this$userProfileViewType.equals(other$userProfileViewType)) {
            return false;
        }
        Set<String> this$scopes = this.scopes;
        Set<String> other$scopes = other.scopes;
        if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
            return false;
        }
        String this$responseMode = this.responseMode;
        String other$responseMode = other.responseMode;
        if (this$responseMode == null ? other$responseMode != null : !this$responseMode.equals(other$responseMode)) {
            return false;
        }
        String this$introspectionSignedResponseAlg = this.introspectionSignedResponseAlg;
        String other$introspectionSignedResponseAlg = other.introspectionSignedResponseAlg;
        if (this$introspectionSignedResponseAlg == null ? other$introspectionSignedResponseAlg != null : !this$introspectionSignedResponseAlg.equals(other$introspectionSignedResponseAlg)) {
            return false;
        }
        String this$introspectionEncryptedResponseAlg = this.introspectionEncryptedResponseAlg;
        String other$introspectionEncryptedResponseAlg = other.introspectionEncryptedResponseAlg;
        if (this$introspectionEncryptedResponseAlg == null ? other$introspectionEncryptedResponseAlg != null : !this$introspectionEncryptedResponseAlg.equals(other$introspectionEncryptedResponseAlg)) {
            return false;
        }
        String this$introspectionEncryptedResponseEncoding = this.introspectionEncryptedResponseEncoding;
        String other$introspectionEncryptedResponseEncoding = other.introspectionEncryptedResponseEncoding;
        if (this$introspectionEncryptedResponseEncoding == null ? other$introspectionEncryptedResponseEncoding != null : !this$introspectionEncryptedResponseEncoding.equals(other$introspectionEncryptedResponseEncoding)) {
            return false;
        }
        String this$tokenEndpointAuthenticationMethod = this.tokenEndpointAuthenticationMethod;
        String other$tokenEndpointAuthenticationMethod = other.tokenEndpointAuthenticationMethod;
        if (this$tokenEndpointAuthenticationMethod == null ? other$tokenEndpointAuthenticationMethod != null : !this$tokenEndpointAuthenticationMethod.equals(other$tokenEndpointAuthenticationMethod)) {
            return false;
        }
        String this$tlsClientAuthSubjectDn = this.tlsClientAuthSubjectDn;
        String other$tlsClientAuthSubjectDn = other.tlsClientAuthSubjectDn;
        if (this$tlsClientAuthSubjectDn == null ? other$tlsClientAuthSubjectDn != null : !this$tlsClientAuthSubjectDn.equals(other$tlsClientAuthSubjectDn)) {
            return false;
        }
        String this$tlsClientAuthSanDns = this.tlsClientAuthSanDns;
        String other$tlsClientAuthSanDns = other.tlsClientAuthSanDns;
        if (this$tlsClientAuthSanDns == null ? other$tlsClientAuthSanDns != null : !this$tlsClientAuthSanDns.equals(other$tlsClientAuthSanDns)) {
            return false;
        }
        String this$tlsClientAuthSanUri = this.tlsClientAuthSanUri;
        String other$tlsClientAuthSanUri = other.tlsClientAuthSanUri;
        if (this$tlsClientAuthSanUri == null ? other$tlsClientAuthSanUri != null : !this$tlsClientAuthSanUri.equals(other$tlsClientAuthSanUri)) {
            return false;
        }
        String this$tlsClientAuthSanIp = this.tlsClientAuthSanIp;
        String other$tlsClientAuthSanIp = other.tlsClientAuthSanIp;
        if (this$tlsClientAuthSanIp == null ? other$tlsClientAuthSanIp != null : !this$tlsClientAuthSanIp.equals(other$tlsClientAuthSanIp)) {
            return false;
        }
        String this$tlsClientAuthSanEmail = this.tlsClientAuthSanEmail;
        String other$tlsClientAuthSanEmail = other.tlsClientAuthSanEmail;
        return !(this$tlsClientAuthSanEmail == null ? other$tlsClientAuthSanEmail != null : !this$tlsClientAuthSanEmail.equals(other$tlsClientAuthSanEmail));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuthRegisteredService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bypassApprovalPrompt ? 79 : 97);
        result = result * 59 + (this.generateRefreshToken ? 79 : 97);
        result = result * 59 + (this.renewRefreshToken ? 79 : 97);
        result = result * 59 + (this.jwtAccessToken ? 79 : 97);
        result = result * 59 + (this.jwtRefreshToken ? 79 : 97);
        String $clientSecret = this.clientSecret;
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $clientId = this.clientId;
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $jwtAccessTokenSigningAlg = this.jwtAccessTokenSigningAlg;
        result = result * 59 + ($jwtAccessTokenSigningAlg == null ? 43 : $jwtAccessTokenSigningAlg.hashCode());
        Set<String> $audience = this.audience;
        result = result * 59 + ($audience == null ? 43 : ((Object)$audience).hashCode());
        RegisteredServiceOAuthCodeExpirationPolicy $codeExpirationPolicy = this.codeExpirationPolicy;
        result = result * 59 + ($codeExpirationPolicy == null ? 43 : $codeExpirationPolicy.hashCode());
        RegisteredServiceOAuthAccessTokenExpirationPolicy $accessTokenExpirationPolicy = this.accessTokenExpirationPolicy;
        result = result * 59 + ($accessTokenExpirationPolicy == null ? 43 : $accessTokenExpirationPolicy.hashCode());
        RegisteredServiceOAuthRefreshTokenExpirationPolicy $refreshTokenExpirationPolicy = this.refreshTokenExpirationPolicy;
        result = result * 59 + ($refreshTokenExpirationPolicy == null ? 43 : $refreshTokenExpirationPolicy.hashCode());
        RegisteredServiceOAuthDeviceTokenExpirationPolicy $deviceTokenExpirationPolicy = this.deviceTokenExpirationPolicy;
        result = result * 59 + ($deviceTokenExpirationPolicy == null ? 43 : $deviceTokenExpirationPolicy.hashCode());
        RegisteredServiceOAuthTokenExchangePolicy $tokenExchangePolicy = this.tokenExchangePolicy;
        result = result * 59 + ($tokenExchangePolicy == null ? 43 : $tokenExchangePolicy.hashCode());
        Set<String> $supportedGrantTypes = this.supportedGrantTypes;
        result = result * 59 + ($supportedGrantTypes == null ? 43 : ((Object)$supportedGrantTypes).hashCode());
        Set<String> $supportedResponseTypes = this.supportedResponseTypes;
        result = result * 59 + ($supportedResponseTypes == null ? 43 : ((Object)$supportedResponseTypes).hashCode());
        OAuthCoreProperties.UserProfileViewTypes $userProfileViewType = this.userProfileViewType;
        result = result * 59 + ($userProfileViewType == null ? 43 : $userProfileViewType.hashCode());
        Set<String> $scopes = this.scopes;
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        String $responseMode = this.responseMode;
        result = result * 59 + ($responseMode == null ? 43 : $responseMode.hashCode());
        String $introspectionSignedResponseAlg = this.introspectionSignedResponseAlg;
        result = result * 59 + ($introspectionSignedResponseAlg == null ? 43 : $introspectionSignedResponseAlg.hashCode());
        String $introspectionEncryptedResponseAlg = this.introspectionEncryptedResponseAlg;
        result = result * 59 + ($introspectionEncryptedResponseAlg == null ? 43 : $introspectionEncryptedResponseAlg.hashCode());
        String $introspectionEncryptedResponseEncoding = this.introspectionEncryptedResponseEncoding;
        result = result * 59 + ($introspectionEncryptedResponseEncoding == null ? 43 : $introspectionEncryptedResponseEncoding.hashCode());
        String $tokenEndpointAuthenticationMethod = this.tokenEndpointAuthenticationMethod;
        result = result * 59 + ($tokenEndpointAuthenticationMethod == null ? 43 : $tokenEndpointAuthenticationMethod.hashCode());
        String $tlsClientAuthSubjectDn = this.tlsClientAuthSubjectDn;
        result = result * 59 + ($tlsClientAuthSubjectDn == null ? 43 : $tlsClientAuthSubjectDn.hashCode());
        String $tlsClientAuthSanDns = this.tlsClientAuthSanDns;
        result = result * 59 + ($tlsClientAuthSanDns == null ? 43 : $tlsClientAuthSanDns.hashCode());
        String $tlsClientAuthSanUri = this.tlsClientAuthSanUri;
        result = result * 59 + ($tlsClientAuthSanUri == null ? 43 : $tlsClientAuthSanUri.hashCode());
        String $tlsClientAuthSanIp = this.tlsClientAuthSanIp;
        result = result * 59 + ($tlsClientAuthSanIp == null ? 43 : $tlsClientAuthSanIp.hashCode());
        String $tlsClientAuthSanEmail = this.tlsClientAuthSanEmail;
        result = result * 59 + ($tlsClientAuthSanEmail == null ? 43 : $tlsClientAuthSanEmail.hashCode());
        return result;
    }
}

