/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.filter;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apereo.cas.util.LoggingUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.AbstractMetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.X509Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDescriptorCertificatesExpirationFilter
extends AbstractMetadataFilter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityDescriptorCertificatesExpirationFilter.class);

    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        if (metadata instanceof EntityDescriptor) {
            EntityDescriptor ed = (EntityDescriptor)metadata;
            for (RoleDescriptor role : ed.getRoleDescriptors()) {
                for (KeyDescriptor kd : role.getKeyDescriptors()) {
                    KeyInfo ki = kd.getKeyInfo();
                    for (X509Data x509 : ki.getX509Datas()) {
                        for (org.opensaml.xmlsec.signature.X509Certificate xmlCert : x509.getX509Certificates()) {
                            try {
                                X509Certificate cert = X509Support.decodeCertificate((String)xmlCert.getValue());
                                LOGGER.debug("Evaluating certificate [{}] in metadata for [{}]. Not Before [{}], Not After [{}]", new Object[]{cert.getSubjectX500Principal().getName(), ed.getEntityID(), cert.getNotBefore(), cert.getNotAfter()});
                                cert.checkValidity();
                            }
                            catch (CertificateException e) {
                                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                                throw new FilterException("Expired or invalid certificate in metadata for " + ed.getEntityID());
                            }
                        }
                    }
                }
            }
        }
        return metadata;
    }
}

