/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.inspektr.audit.annotation.Audit;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class GroovyResourceMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyResourceMetadataResolver.class);

    public GroovyResourceMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
    }

    @Override
    @Audit(action="SAML2_METADATA_RESOLUTION", actionResolverName="SAML2_METADATA_RESOLUTION_ACTION_RESOLVER", resourceResolverName="SAML2_METADATA_RESOLUTION_RESOURCE_RESOLVER")
    public Collection<? extends MetadataResolver> resolve(SamlRegisteredService service, CriteriaSet criteriaSet) {
        return (Collection)FunctionUtils.doAndHandle(() -> {
            String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
            LOGGER.info("Loading SAML metadata via [{}]", (Object)metadataLocation);
            AbstractResource metadataResource = ResourceUtils.getResourceFrom((String)metadataLocation);
            Object[] args = new Object[]{service, this.configBean, this.samlIdPProperties, criteriaSet, LOGGER};
            ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
            MetadataResolver metadataResolver = (MetadataResolver)scriptFactory.fromResource((Resource)metadataResource).execute(args, MetadataResolver.class, true);
            return CollectionUtils.wrap((Object)metadataResolver);
        }, e -> new ArrayList()).get();
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
        Optional scriptFactoryInstance = ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory();
        return scriptFactoryInstance.isPresent() && ((ExecutableCompiledScriptFactory)scriptFactoryInstance.get()).isExternalScript(metadataLocation);
    }

    @Override
    public boolean isAvailable(SamlRegisteredService service) {
        if (this.supports(service)) {
            String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
            return ResourceUtils.doesResourceExist((String)metadataLocation);
        }
        return false;
    }
}

