/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.jdbc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.impl.BasePasswordManagementService;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.support.TransactionOperations;

public class JdbcPasswordManagementService
extends BasePasswordManagementService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcPasswordManagementService.class);
    private final JdbcTemplate jdbcTemplate;
    private final TransactionOperations transactionTemplate;
    private final PasswordEncoder passwordEncoder;

    public JdbcPasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, CasConfigurationProperties casProperties, @NonNull DataSource dataSource, @NonNull TransactionOperations transactionTemplate, PasswordHistoryService passwordHistoryService, PasswordEncoder passwordEncoder) {
        super(casProperties, cipherExecutor, passwordHistoryService);
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (transactionTemplate == null) {
            throw new NullPointerException("transactionTemplate is marked non-null but is null");
        }
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.transactionTemplate = transactionTemplate;
        this.passwordEncoder = passwordEncoder;
    }

    public boolean changeInternal(PasswordChangeRequest bean) {
        Boolean result = (Boolean)this.transactionTemplate.execute(action -> {
            String password = this.passwordEncoder.encode((CharSequence)bean.toPassword());
            int count = this.jdbcTemplate.update(this.casProperties.getAuthn().getPm().getJdbc().getSqlChangePassword(), new Object[]{password, bean.getUsername()});
            return count > 0;
        });
        return BooleanUtils.toBoolean((Boolean)result);
    }

    public String findEmail(PasswordManagementQuery query) {
        String queryFindEmail = this.casProperties.getAuthn().getPm().getJdbc().getSqlFindEmail();
        if (StringUtils.isBlank((CharSequence)queryFindEmail)) {
            LOGGER.debug("No SQL query is defined to retrieve email addresses");
            return null;
        }
        try {
            return (String)this.transactionTemplate.execute(action -> {
                String email = (String)this.jdbcTemplate.queryForObject(queryFindEmail, String.class, new Object[]{query.getUsername()});
                if (StringUtils.isNotBlank((CharSequence)email) && EmailValidator.getInstance().isValid(email)) {
                    return email;
                }
                LOGGER.debug("Username [{}] not found when searching for email", (Object)query.getUsername());
                return null;
            });
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.debug("Username [{}] not found when searching for email", (Object)query.getUsername());
            return null;
        }
    }

    public String findPhone(PasswordManagementQuery query) {
        String findPhone = this.casProperties.getAuthn().getPm().getJdbc().getSqlFindPhone();
        if (StringUtils.isBlank((CharSequence)findPhone)) {
            LOGGER.debug("No SQL query is defined to retrieve phone numbers");
            return null;
        }
        try {
            return (String)this.transactionTemplate.execute(action -> {
                String phone = (String)this.jdbcTemplate.queryForObject(findPhone, String.class, new Object[]{query.getUsername()});
                if (StringUtils.isNotBlank((CharSequence)phone)) {
                    return phone;
                }
                LOGGER.debug("Username [{}] not found when searching for phone", (Object)query.getUsername());
                return null;
            });
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.debug("Username [{}] not found when searching for phone", (Object)query.getUsername());
            return null;
        }
    }

    public String findUsername(PasswordManagementQuery query) {
        try {
            return (String)this.transactionTemplate.execute(action -> (String)this.jdbcTemplate.queryForObject(this.casProperties.getAuthn().getPm().getJdbc().getSqlFindUser(), String.class, new Object[]{query.getEmail()}));
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.debug("Email [{}] not found when searching for user", (Object)query.getEmail());
            return null;
        }
    }

    public Map<String, String> getSecurityQuestions(PasswordManagementQuery query) {
        return (Map)this.transactionTemplate.execute(action -> {
            String sqlSecurityQuestions = this.casProperties.getAuthn().getPm().getJdbc().getSqlGetSecurityQuestions();
            HashMap map = new HashMap();
            List results = this.jdbcTemplate.queryForList(sqlSecurityQuestions, new Object[]{query.getUsername()});
            results.forEach(row -> {
                if (row.containsKey("question") && row.containsKey("answer")) {
                    map.put(row.get("question").toString(), row.get("answer").toString());
                }
            });
            LOGGER.debug("Found [{}] security questions for [{}]", (Object)map.size(), (Object)query.getUsername());
            return map;
        });
    }

    public void updateSecurityQuestions(PasswordManagementQuery query) {
        this.jdbcTemplate.update(this.casProperties.getAuthn().getPm().getJdbc().getSqlDeleteSecurityQuestions(), new Object[]{query.getUsername()});
        query.getSecurityQuestions().forEach((question, values) -> values.forEach(answer -> this.jdbcTemplate.update(this.casProperties.getAuthn().getPm().getJdbc().getSqlUpdateSecurityQuestions(), new Object[]{query.getUsername(), question, answer})));
    }

    public boolean unlockAccount(Credential credential) {
        return this.jdbcTemplate.update(this.casProperties.getAuthn().getPm().getJdbc().getSqlUnlockAccount(), new Object[]{Boolean.TRUE, credential.getId()}) > 0;
    }

    @Generated
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Generated
    public TransactionOperations getTransactionTemplate() {
        return this.transactionTemplate;
    }

    @Generated
    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }
}

