/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.Serializable;
import javax.sql.DataSource;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.jdbc.JdbcPasswordManagementService;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;

@EnableTransactionManagement(proxyTargetClass=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PasswordManagement}, module="jdbc")
@Configuration(value="JdbcPasswordManagementConfiguration", proxyBeanMethods=false)
class JdbcPasswordManagementConfiguration {
    JdbcPasswordManagementConfiguration() {
    }

    @Configuration(value="JdbcPasswordManagementTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JdbcPasswordManagementTransactionConfiguration {
        JdbcPasswordManagementTransactionConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PlatformTransactionManager jdbcPasswordManagementTransactionManager(@Qualifier(value="jdbcPasswordManagementDataSource") DataSource jdbcPasswordManagementDataSource) {
            return new DataSourceTransactionManager(jdbcPasswordManagementDataSource);
        }

        @ConditionalOnMissingBean(name={"jdbcPasswordManagementTransactionTemplate"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TransactionOperations jdbcPasswordManagementTransactionTemplate(CasConfigurationProperties casProperties, @Qualifier(value="jdbcPasswordManagementTransactionManager") PlatformTransactionManager jdbcPasswordManagementTransactionManager) {
            TransactionTemplate t = new TransactionTemplate(jdbcPasswordManagementTransactionManager);
            t.setIsolationLevelName(casProperties.getAuthn().getPm().getJdbc().getIsolationLevelName());
            t.setPropagationBehaviorName(casProperties.getAuthn().getPm().getJdbc().getPropagationBehaviorName());
            return t;
        }
    }

    @Configuration(value="JdbcPasswordManagementDataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JdbcPasswordManagementDataConfiguration {
        JdbcPasswordManagementDataConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"jdbcPasswordManagementDataSource"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DataSource jdbcPasswordManagementDataSource(CasConfigurationProperties casProperties) {
            return JpaBeans.newDataSource((AbstractJpaProperties)casProperties.getAuthn().getPm().getJdbc());
        }
    }

    @Configuration(value="JdbcPasswordManagementServiceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JdbcPasswordManagementServiceConfiguration {
        JdbcPasswordManagementServiceConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"jdbcPasswordChangeService"})
        public PasswordManagementService passwordChangeService(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="jdbcPasswordManagementDataSource") DataSource jdbcPasswordManagementDataSource, @Qualifier(value="jdbcPasswordManagementTransactionTemplate") TransactionOperations jdbcPasswordManagementTransactionTemplate, @Qualifier(value="passwordManagementCipherExecutor") CipherExecutor passwordManagementCipherExecutor, @Qualifier(value="passwordHistoryService") PasswordHistoryService passwordHistoryService) {
            PasswordEncoder encoder = PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)casProperties.getAuthn().getPm().getJdbc().getPasswordEncoder(), (ApplicationContext)applicationContext);
            return new JdbcPasswordManagementService((CipherExecutor<Serializable, String>)passwordManagementCipherExecutor, casProperties, jdbcPasswordManagementDataSource, jdbcPasswordManagementTransactionTemplate, passwordHistoryService, encoder);
        }
    }
}

