/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.apereo.cas.support.events.web.flow.CasWebflowActionExecutedEvent;
import org.apereo.cas.support.events.web.flow.CasWebflowActionExecutingEvent;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.decorator.WebflowDecorator;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ActionExecutionException;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class BaseCasWebflowAction
extends AbstractAction {
    protected final EventFactorySupport eventFactory = new EventFactorySupport();

    protected static boolean isLoginFlowActive(RequestContext requestContext) {
        String currentFlowId = Optional.ofNullable(requestContext.getActiveFlow()).map(FlowDefinition::getId).orElse("unknown");
        return currentFlowId.equalsIgnoreCase("login");
    }

    protected Event doPreExecute(RequestContext requestContext) throws Exception {
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        FunctionUtils.doIfNotNull((Object)applicationContext, __ -> BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, WebflowDecorator.class).values().stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<WebflowDecorator>)AnnotationAwareOrderComparator.INSTANCE).forEach(Unchecked.consumer(decorator -> decorator.decorate(requestContext))));
        return super.doPreExecute(requestContext);
    }

    protected final Event doExecute(RequestContext requestContext) throws Exception {
        FlowDefinition activeFlow = requestContext.getActiveFlow();
        ApplicationContext applicationContext = activeFlow.getApplicationContext();
        Optional<PlatformTransactionManager> transactionManager = this.getTransactionManager(requestContext);
        Optional<TransactionStatus> transactionStatus = this.getTransaction(transactionManager);
        try {
            WebUtils.putActiveFlow((RequestContext)requestContext);
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            HashMap scope = new HashMap(requestContext.getConversationScope().asMap());
            scope.putAll(requestContext.getFlowScope().asMap());
            scope.putAll(requestContext.getFlashScope().asMap());
            applicationContext.publishEvent((ApplicationEvent)new CasWebflowActionExecutingEvent((Object)this, scope, clientInfo));
            Event result = this.doExecuteInternal(requestContext);
            transactionManager.ifPresent(mgr -> transactionStatus.ifPresent(arg_0 -> ((PlatformTransactionManager)mgr).commit(arg_0)));
            return result;
        }
        catch (Exception e) {
            transactionManager.ifPresent(mgr -> transactionStatus.ifPresent(arg_0 -> ((PlatformTransactionManager)mgr).rollback(arg_0)));
            throw e;
        }
        catch (Throwable e) {
            transactionManager.ifPresent(mgr -> transactionStatus.ifPresent(arg_0 -> ((PlatformTransactionManager)mgr).rollback(arg_0)));
            String currentState = Optional.ofNullable(requestContext.getCurrentState()).map(StateDefinition::getId).orElse("unknown");
            throw new ActionExecutionException(activeFlow.getId(), currentState, (Action)this, (AttributeMap)requestContext.getAttributes(), e);
        }
    }

    protected void doPostExecute(RequestContext requestContext) throws Exception {
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        HashMap scope = new HashMap(requestContext.getConversationScope().asMap());
        scope.putAll(requestContext.getFlowScope().asMap());
        scope.putAll(requestContext.getFlashScope().asMap());
        applicationContext.publishEvent((ApplicationEvent)new CasWebflowActionExecutedEvent((Object)this, scope, clientInfo));
    }

    protected abstract Event doExecuteInternal(RequestContext var1) throws Throwable;

    protected Optional<TransactionStatus> getTransaction(Optional<PlatformTransactionManager> transactionManager) {
        return transactionManager.map(manager -> {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setName(((Object)((Object)this)).getClass().getSimpleName() + "-TransactionID-" + String.valueOf(UUID.randomUUID()));
            def.setPropagationBehavior(0);
            return manager.getTransaction((TransactionDefinition)def);
        });
    }

    protected Optional<PlatformTransactionManager> getTransactionManager(RequestContext requestContext) {
        Transactional annotation = (Transactional)AnnotationUtils.findAnnotation(((Object)((Object)this)).getClass(), Transactional.class);
        return (Optional)FunctionUtils.doIfNotNull((Object)annotation, () -> {
            FlowDefinition activeFlow = requestContext.getActiveFlow();
            ApplicationContext applicationContext = activeFlow.getApplicationContext();
            String transactionManagerName = annotation.transactionManager();
            return Optional.of((PlatformTransactionManager)applicationContext.getBean(transactionManagerName, PlatformTransactionManager.class));
        }, Optional::empty).get();
    }
}

