/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;

@Endpoint(id="events", defaultAccess=Access.NONE)
@EnableTransactionManagement(proxyTargetClass=false)
@Transactional(transactionManager="transactionManagerEvents")
public class CasEventsReportEndpoint
extends BaseCasRestActuatorEndpoint {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ObjectProvider<CasEventRepository> eventRepositoryProvider;

    public CasEventsReportEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<CasEventRepository> eventRepositoryProvider) {
        super(casProperties, applicationContext);
        this.eventRepositoryProvider = eventRepositoryProvider;
    }

    @DeleteMapping
    @Operation(summary="Delete all CAS events in the event repository")
    public ResponseEntity deleteAllEvents() {
        ((CasEventRepository)this.eventRepositoryProvider.getObject()).removeAll();
        return ResponseEntity.ok().build();
    }

    @GetMapping(produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/x-www-form-urlencoded", "application/vnd.cas.services+yaml", "application/x-ndjson"})
    @Operation(summary="Provide a report of CAS events in the event repository", parameters={@Parameter(name="limit", required=false, description="Limit the number of events to fetch")})
    public ResponseBodyEmitter events(HttpServletResponse response, @RequestParam(required=false, defaultValue="1000") int limit) throws Exception {
        response.setContentType("application/x-ndjson");
        ResponseBodyEmitter emitter = new ResponseBodyEmitter();
        this.executor.submit(() -> ((CasEventRepository)this.eventRepositoryProvider.getObject()).withTransaction(__ -> {
            try (Stream<CasEvent> stream = ((CasEventRepository)this.eventRepositoryProvider.getObject()).load().sorted(Comparator.comparingLong(CasEvent::getTimestamp).reversed()).limit(limit);){
                emitter.send((Object)"[", MediaType.APPLICATION_JSON);
                AtomicBoolean first = new AtomicBoolean(true);
                stream.forEach(Unchecked.consumer(pojo -> {
                    if (!first.getAndSet(false)) {
                        emitter.send((Object)",");
                    }
                    emitter.send((Object)MAPPER.writeValueAsString(pojo), MediaType.APPLICATION_JSON);
                }));
                emitter.send((Object)"]", MediaType.APPLICATION_JSON);
                emitter.complete();
            }
            catch (Exception e) {
                emitter.completeWithError((Throwable)e);
            }
        }));
        return emitter;
    }

    @GetMapping(path={"/aggregate"}, produces={"application/x-ndjson"})
    @Operation(summary="Provide an aggregated report of CAS events in the event repository")
    public ResponseBodyEmitter aggregate() throws Exception {
        ResponseBodyEmitter emitter = new ResponseBodyEmitter();
        this.executor.submit(() -> {
            try (Stream stream = ((CasEventRepository)this.eventRepositoryProvider.getObject()).aggregate();){
                stream.forEach(Unchecked.consumer(pojo -> emitter.send((Object)MAPPER.writeValueAsString(pojo), MediaType.APPLICATION_JSON)));
                emitter.complete();
            }
            catch (Exception e) {
                emitter.completeWithError((Throwable)e);
            }
        });
        return emitter;
    }

    @PostMapping(produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/x-www-form-urlencoded", "application/vnd.cas.services+yaml"})
    @Operation(summary="Upload CAS events and store them into the event repository")
    public ResponseEntity uploadEvents(HttpServletRequest request) throws Throwable {
        String contentType = request.getContentType();
        if (Strings.CI.equalsAny((CharSequence)"application/octet-stream", new CharSequence[]{contentType})) {
            return this.importEventsAsStream(request);
        }
        return this.importSingleEvent(request);
    }

    private ResponseEntity<CasEvent> importSingleEvent(HttpServletRequest request) throws Throwable {
        CasEventRepository eventRepository = (CasEventRepository)this.eventRepositoryProvider.getObject();
        try (ServletInputStream in = request.getInputStream();){
            String requestBody = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            CasEvent casEvent = (CasEvent)MAPPER.readValue(requestBody, CasEvent.class);
            eventRepository.save(CasEvent.from((CasEvent)casEvent).asNewEntity());
            ResponseEntity responseEntity = ResponseEntity.ok().build();
            return responseEntity;
        }
    }

    private ResponseEntity<CasEvent> importEventsAsStream(HttpServletRequest request) throws Throwable {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)request.getInputStream()));
             ZipInputStream zipIn = new ZipInputStream(bais);){
            ZipEntry entry = zipIn.getNextEntry();
            CasEventRepository eventRepository = (CasEventRepository)this.eventRepositoryProvider.getObject();
            while (entry != null) {
                if (!entry.isDirectory() && !entry.getName().contains("..") && entry.getName().endsWith(".json")) {
                    String requestBody = IOUtils.toString((InputStream)zipIn, (Charset)StandardCharsets.UTF_8);
                    CasEvent casEvent = (CasEvent)MAPPER.readValue(requestBody, CasEvent.class);
                    eventRepository.save(CasEvent.from((CasEvent)casEvent).asNewEntity());
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        return ResponseEntity.ok().build();
    }
}

