/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.listener;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationResponse;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.LogoutRequestStatus;
import org.apereo.cas.logout.slo.SingleLogoutExecutionRequest;
import org.apereo.cas.support.events.AbstractCasEvent;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.authentication.CasAuthenticationPolicyFailureEvent;
import org.apereo.cas.support.events.authentication.CasAuthenticationTransactionFailureEvent;
import org.apereo.cas.support.events.authentication.adaptive.CasRiskyAuthenticationDetectedEvent;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.support.events.listener.CasAuthenticationEventListener;
import org.apereo.cas.support.events.logout.CasRequestSingleLogoutEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketCreatedEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketDestroyedEvent;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.apereo.cas.util.text.MessageSanitizer;
import org.apereo.inspektr.common.web.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasAuthenticationAuthenticationEventListener
implements CasAuthenticationEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasAuthenticationAuthenticationEventListener.class);
    private final CasEventRepository casEventRepository;
    private final MessageSanitizer messageSanitizer;
    private final GeoLocationService geoLocationService;
    private final LogoutManager logoutManager;

    protected CasEvent prepareCasEvent(AbstractCasEvent event) {
        CasEvent dto = new CasEvent();
        dto.setType(event.getClass().getCanonicalName());
        dto.putTimestamp(Long.valueOf(event.getTimestamp()));
        ZonedDateTime dt = DateTimeUtils.zonedDateTimeOf((Instant)Instant.ofEpochMilli(event.getTimestamp()));
        dto.setCreationTime(dt.toInstant());
        ClientInfo clientInfo = event.getClientInfo();
        FunctionUtils.doIfNotNull((Object)clientInfo, __ -> {
            dto.putClientIpAddress(clientInfo.getClientIpAddress());
            dto.putServerIpAddress(clientInfo.getServerIpAddress());
            dto.putAgent(clientInfo.getUserAgent());
            GeoLocationRequest location = this.determineGeoLocationFor(clientInfo);
            dto.putGeoLocation(location);
            dto.putDeviceFingerprint(clientInfo.getDeviceFingerprint());
            dto.putTenant(clientInfo.getTenant());
        });
        return dto;
    }

    protected GeoLocationRequest determineGeoLocationFor(ClientInfo clientInfo) {
        GeoLocationResponse geoResponse;
        GeoLocationRequest geoLocationRequest = HttpRequestUtils.getHttpServletRequestGeoLocation((String)clientInfo.getGeoLocation());
        if (!geoLocationRequest.isValid() && this.geoLocationService != null && (geoResponse = this.geoLocationService.locate(clientInfo.getClientIpAddress())) != null) {
            return new GeoLocationRequest(geoResponse.getLatitude(), geoResponse.getLongitude()).setAddress(geoResponse.build());
        }
        return geoLocationRequest;
    }

    @Override
    public void handleCasTicketGrantingTicketCreatedEvent(CasTicketGrantingTicketCreatedEvent event) throws Throwable {
        CasEvent dto = this.prepareCasEvent((AbstractCasEvent)event);
        dto.setCreationTime(event.getTicketGrantingTicket().getCreationTime().toInstant());
        dto.putEventId(this.messageSanitizer.sanitize(event.getTicketGrantingTicket().getId()));
        dto.setPrincipalId(event.getTicketGrantingTicket().getAuthentication().getPrincipal().getId());
        this.casEventRepository.save(dto);
    }

    @Override
    public void handleCasTicketGrantingTicketDeletedEvent(CasTicketGrantingTicketDestroyedEvent event) throws Throwable {
        CasEvent dto = this.prepareCasEvent((AbstractCasEvent)event);
        dto.setCreationTime(event.getTicketGrantingTicket().getCreationTime().toInstant());
        dto.putEventId(this.messageSanitizer.sanitize(event.getTicketGrantingTicket().getId()));
        dto.setPrincipalId(event.getTicketGrantingTicket().getAuthentication().getPrincipal().getId());
        this.casEventRepository.save(dto);
    }

    @Override
    public void handleCasAuthenticationTransactionFailureEvent(CasAuthenticationTransactionFailureEvent event) throws Throwable {
        CasEvent dto = this.prepareCasEvent((AbstractCasEvent)event);
        dto.setPrincipalId(event.getCredential().getId());
        dto.putEventId(CasAuthenticationTransactionFailureEvent.class.getSimpleName());
        this.casEventRepository.save(dto);
    }

    @Override
    public void handleCasAuthenticationPolicyFailureEvent(CasAuthenticationPolicyFailureEvent event) throws Throwable {
        CasEvent dto = this.prepareCasEvent((AbstractCasEvent)event);
        dto.setPrincipalId(event.getAuthentication().getPrincipal().getId());
        dto.putEventId(CasAuthenticationPolicyFailureEvent.class.getSimpleName());
        this.casEventRepository.save(dto);
    }

    @Override
    public void handleCasRiskyAuthenticationDetectedEvent(CasRiskyAuthenticationDetectedEvent event) throws Throwable {
        CasEvent dto = this.prepareCasEvent((AbstractCasEvent)event);
        dto.putEventId(event.getService().getName());
        dto.setPrincipalId(event.getAuthentication().getPrincipal().getId());
        this.casEventRepository.save(dto);
    }

    @Override
    public void handleCasRequestSingleLogoutEvent(CasRequestSingleLogoutEvent event) {
        try {
            TicketGrantingTicket ticket = event.getTicketGrantingTicket();
            LOGGER.debug("Performing single logout for expired ticket-granting ticket [{}]", (Object)ticket.getId());
            SingleLogoutExecutionRequest request = SingleLogoutExecutionRequest.builder().ticketGrantingTicket(ticket).build();
            List results = this.logoutManager.performLogout(request);
            results.stream().filter(r -> r.getStatus() == LogoutRequestStatus.FAILURE).forEach(r -> LOGGER.warn("Logout request for [{}] and [{}] has failed", (Object)r.getTicketId(), (Object)r.getLogoutUrl()));
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
    }

    @Generated
    public CasAuthenticationAuthenticationEventListener(CasEventRepository casEventRepository, MessageSanitizer messageSanitizer, GeoLocationService geoLocationService, LogoutManager logoutManager) {
        this.casEventRepository = casEventRepository;
        this.messageSanitizer = messageSanitizer;
        this.geoLocationService = geoLocationService;
        this.logoutManager = logoutManager;
    }

    @Generated
    public CasEventRepository getCasEventRepository() {
        return this.casEventRepository;
    }

    @Generated
    public MessageSanitizer getMessageSanitizer() {
        return this.messageSanitizer;
    }

    @Generated
    public GeoLocationService getGeoLocationService() {
        return this.geoLocationService;
    }

    @Generated
    public LogoutManager getLogoutManager() {
        return this.logoutManager;
    }
}

