/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.provisioning.api.event.JobStatusEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

public class JobStatusUpdater {
    protected static final Logger LOG = LoggerFactory.getLogger(JobStatusUpdater.class);
    protected final JobStatusDAO jobStatusDAO;
    protected boolean initCompleted = false;

    public JobStatusUpdater(JobStatusDAO jobStatusDAO) {
        this.jobStatusDAO = jobStatusDAO;
    }

    public void initComplete() {
        this.initCompleted = true;
    }

    @Async(value="jobStatusUpdaterThreadExecutor")
    @EventListener
    public void update(JobStatusEvent event) {
        if (!this.initCompleted) {
            LOG.debug("Core initialization not yet completed, discarding {}", (Object)event);
            return;
        }
        if (event.getJobStatus() == null) {
            LOG.debug("Requesting to delete status for job '{}#{}', ignoring", (Object)event.getDomain(), (Object)event.getJobName());
        } else {
            LOG.debug("Updating job '{}#{}' with status '{}'", new Object[]{event.getDomain(), event.getJobName(), event.getJobStatus()});
            AuthContextUtils.runAsAdmin((String)event.getDomain(), () -> this.jobStatusDAO.set(event.getJobName(), event.getJobStatus()));
        }
    }
}

