/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token.ciba;

import java.util.Map;
import lombok.Generated;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.ticket.OidcCibaRequest;
import org.apereo.cas.oidc.token.ciba.CibaTokenDeliveryHandler;
import org.apereo.cas.services.OidcBackchannelTokenDeliveryModes;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.ticket.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CibaPollTokenDeliveryHandler
implements CibaTokenDeliveryHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CibaPollTokenDeliveryHandler.class);
    private final OidcBackchannelTokenDeliveryModes deliveryMode = OidcBackchannelTokenDeliveryModes.POLL;
    private final OidcConfigurationContext configurationContext;

    @Override
    public Map<String, ?> deliver(OidcRegisteredService registeredService, OidcCibaRequest cibaRequest) throws Throwable {
        LOGGER.debug("Marking CIBA authentication request [{}] as ready", (Object)cibaRequest.getEncodedId());
        this.configurationContext.getTicketRegistry().updateTicket((Ticket)cibaRequest.markTicketReady());
        return Map.of("auth_req_id", cibaRequest.getEncodedId());
    }

    @Generated
    public CibaPollTokenDeliveryHandler(OidcConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Override
    @Generated
    public OidcBackchannelTokenDeliveryModes getDeliveryMode() {
        return this.deliveryMode;
    }

    @Generated
    public OidcConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }
}

