/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.multitenancy;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.multitenancy.TenantsManager;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class DefaultTenantExtractor
implements TenantExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTenantExtractor.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).minimal(true).sorted(true).build().toObjectMapper();
    private final TenantsManager tenantsManager;
    private final ApplicationContext applicationContext;
    private final CasConfigurationProperties casProperties;

    public Optional<TenantDefinition> extract(String requestPath) {
        String tenantId = this.casProperties.getMultitenancy().getCore().isEnabled() ? TenantExtractor.tenantIdFromPath((String)requestPath) : "";
        return StringUtils.isNotBlank((CharSequence)tenantId) ? this.tenantsManager.findTenant(tenantId) : Optional.empty();
    }

    public String getTenantKey(TenantDefinition tenantDefinition) {
        return (String)FunctionUtils.doUnchecked(() -> {
            String record = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)tenantDefinition);
            return DigestUtils.sha512((String)record);
        });
    }

    @Generated
    public DefaultTenantExtractor(TenantsManager tenantsManager, ApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        this.tenantsManager = tenantsManager;
        this.applicationContext = applicationContext;
        this.casProperties = casProperties;
    }

    @Generated
    public TenantsManager getTenantsManager() {
        return this.tenantsManager;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

