/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.RelationshipTypeModalPanel;
import org.apache.syncope.client.console.panels.TypeExtensionDirectoryPanel;
import org.apache.syncope.client.console.panels.TypesDirectoryPanel;
import org.apache.syncope.client.console.rest.RelationshipTypeRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.panels.WizardModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.to.RelationshipTypeTO;
import org.apache.syncope.common.lib.to.TypeExtensionHolderTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class RelationshipTypesPanel
extends TypesDirectoryPanel<RelationshipTypeTO, RelationshipTypeProvider, RelationshipTypeRestClient> {
    private static final long serialVersionUID = -3731778000138547357L;
    protected final BaseModal<Serializable> typeExtensionsModal = new BaseModal("outer");

    public RelationshipTypesPanel(String id, final RelationshipTypeRestClient restClient, PageReference pageRef) {
        super(id, restClient, false, pageRef);
        this.disableCheckBoxes();
        this.typeExtensionsModal.size(Modal.Size.Large);
        this.typeExtensionsModal.addSubmitButton();
        this.setWindowClosedReloadCallback(this.typeExtensionsModal);
        this.addOuterObject(new Component[]{this.typeExtensionsModal});
        this.addNewItemPanelBuilder(new AbstractModalPanelBuilder<RelationshipTypeTO>(this, new RelationshipTypeTO(), pageRef){
            private static final long serialVersionUID = -6388405037134399367L;
            final /* synthetic */ RelationshipTypesPanel this$0;
            {
                this.this$0 = this$0;
                super((Serializable)defaultItem, pageRef);
            }

            public WizardModalPanel<RelationshipTypeTO> build(String id, int index, AjaxWizard.Mode mode) {
                final RelationshipTypeTO modelObject = (RelationshipTypeTO)this.newModelObject();
                return new RelationshipTypeModalPanel(this, this.this$0.modal, modelObject, this.pageRef){
                    private static final long serialVersionUID = -6227956682141146094L;
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(modal, relationshipTypeTO, pageRef);
                    }

                    @Override
                    public void onSubmit(AjaxRequestTarget target) {
                        try {
                            if (this.this$1.getOriginalItem() == null || StringUtils.isBlank((CharSequence)((RelationshipTypeTO)this.this$1.getOriginalItem()).getKey())) {
                                restClient.create(modelObject);
                            } else {
                                restClient.update(modelObject);
                            }
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                            this.this$1.this$0.updateResultTable(target);
                            this.modal.close((IPartialPageRequestHandler)target);
                        }
                        catch (Exception e) {
                            LOG.error("While creating or updating {}", (Object)modelObject, (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                };
            }
        }, true);
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"RELATIONSHIPTYPE_CREATE");
    }

    @Override
    protected RelationshipTypeProvider dataProvider() {
        return new RelationshipTypeProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "relationshiptype.painator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    @Override
    protected List<IColumn<RelationshipTypeTO, String>> getColumns() {
        ArrayList<IColumn<RelationshipTypeTO, String>> columns = new ArrayList<IColumn<RelationshipTypeTO, String>>();
        columns.add((IColumn<RelationshipTypeTO, String>)new PropertyColumn((IModel)new ResourceModel("key"), (Object)"key", "key"));
        columns.add((IColumn<RelationshipTypeTO, String>)new PropertyColumn((IModel)new ResourceModel("description"), (Object)"description", "description"));
        columns.add((IColumn<RelationshipTypeTO, String>)new PropertyColumn((IModel)new ResourceModel("leftEndAnyType"), (Object)"leftEndAnyType", "leftEndAnyType"));
        columns.add((IColumn<RelationshipTypeTO, String>)new PropertyColumn((IModel)new ResourceModel("rightEndAnyType"), (Object)"rightEndAnyType", "rightEndAnyType"));
        return columns;
    }

    @Override
    public ActionsPanel<RelationshipTypeTO> getActions(final IModel<RelationshipTypeTO> model) {
        ActionsPanel<RelationshipTypeTO> panel = super.getActions(model);
        panel.add(new ActionLink<RelationshipTypeTO>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ RelationshipTypesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onClick(AjaxRequestTarget target, RelationshipTypeTO ignore) {
                this.this$0.send((IEventSink)this.this$0, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((RelationshipTypeTO)model.getObject()), target));
            }
        }, ActionLink.ActionType.EDIT, "RELATIONSHIPTYPE_UPDATE");
        panel.add(new ActionLink<RelationshipTypeTO>(this){
            private static final long serialVersionUID = 6242834621660352855L;
            final /* synthetic */ RelationshipTypesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onClick(AjaxRequestTarget target, RelationshipTypeTO ignore) {
                target.add(new Component[]{this.this$0.typeExtensionsModal.setContent((ModalPanel)new TypeExtensionDirectoryPanel(this, this.this$0.typeExtensionsModal, (TypeExtensionHolderTO)model.getObject(), this.this$0.pageRef){
                    private static final long serialVersionUID = -2603789363348077538L;
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        super(baseModal, typeExtensionHolder, pageRef);
                    }

                    public void onSubmit(AjaxRequestTarget target) {
                        try {
                            ((RelationshipTypeRestClient)this.this$1.this$0.restClient).update((RelationshipTypeTO)model.getObject());
                            this.baseModal.show(false);
                            this.baseModal.close((IPartialPageRequestHandler)target);
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        }
                        catch (Exception e) {
                            LOG.error("RelationshipType update failure", (Throwable)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                this.this$0.typeExtensionsModal.header((IModel)new StringResourceModel("typeExtensions", model));
                this.this$0.typeExtensionsModal.show(true);
            }
        }, ActionLink.ActionType.TYPE_EXTENSIONS, "RELATIONSHIPTYPE_UPDATE");
        panel.add(new ActionLink<RelationshipTypeTO>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ RelationshipTypesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onClick(AjaxRequestTarget target, RelationshipTypeTO ignore) {
                try {
                    ((RelationshipTypeRestClient)this.this$0.restClient).delete(((RelationshipTypeTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.this$0.getString("operation_succeeded")));
                    target.add(new Component[]{this.this$0.container});
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("While deleting {}", model.getObject(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BasePage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "RELATIONSHIPTYPE_DELETE", true);
        return panel;
    }

    protected final class RelationshipTypeProvider
    extends DirectoryDataProvider<RelationshipTypeTO> {
        private static final long serialVersionUID = -185944053385660794L;
        protected final SortableDataProviderComparator<RelationshipTypeTO> comparator;

        protected RelationshipTypeProvider(int paginatorRows) {
            super(paginatorRows);
            this.comparator = new SortableDataProviderComparator<RelationshipTypeTO>(this);
        }

        public Iterator<RelationshipTypeTO> iterator(long first, long count) {
            List<RelationshipTypeTO> list = ((RelationshipTypeRestClient)RelationshipTypesPanel.this.restClient).list();
            list.sort(this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((RelationshipTypeRestClient)RelationshipTypesPanel.this.restClient).list().size();
        }

        public IModel<RelationshipTypeTO> model(RelationshipTypeTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

